/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class EnvelopeReducer {
    static final EnvelopeReducer UNION = new EnvelopeReducer("union");
    static final EnvelopeReducer INTERSECT = new EnvelopeReducer("intersect"){

        @Override
        void reduce(GeneralEnvelope generalEnvelope, Envelope envelope) {
            generalEnvelope.intersect(envelope);
        }

        @Override
        void reduce(DefaultGeographicBoundingBox defaultGeographicBoundingBox, GeographicBoundingBox geographicBoundingBox) {
            defaultGeographicBoundingBox.intersect(geographicBoundingBox);
        }
    };
    private final String caller;

    EnvelopeReducer(String string) {
        this.caller = string;
    }

    void reduce(GeneralEnvelope generalEnvelope, Envelope envelope) {
        generalEnvelope.add(envelope);
    }

    void reduce(DefaultGeographicBoundingBox defaultGeographicBoundingBox, GeographicBoundingBox geographicBoundingBox) {
        defaultGeographicBoundingBox.add(geographicBoundingBox);
    }

    /*
     * WARNING - void declaration
     */
    final GeneralEnvelope reduce(Envelope[] envelopeArray) throws TransformException {
        void var7_11;
        GeneralEnvelope[] generalEnvelopeArray = new GeneralEnvelope[envelopeArray.length];
        int n = 0;
        block4: for (Envelope object2 : envelopeArray) {
            if (object2 == null) continue;
            CoordinateReferenceSystem coordinateReferenceSystem = object2.getCoordinateReferenceSystem();
            for (int generalEnvelope = 0; generalEnvelope < n; ++generalEnvelope) {
                GeneralEnvelope generalEnvelope2 = generalEnvelopeArray[generalEnvelope];
                if (!Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, generalEnvelope2.getCoordinateReferenceSystem())) continue;
                this.reduce(generalEnvelope2, object2);
                continue block4;
            }
            generalEnvelopeArray[n++] = new GeneralEnvelope(object2);
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return generalEnvelopeArray[0];
            }
        }
        ReferencingServices referencingServices = ReferencingServices.getInstance();
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[n];
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
        Object var7_10 = null;
        for (int i = 0; i < n; ++i) {
            GeneralEnvelope generalEnvelope = generalEnvelopeArray[i];
            coordinateReferenceSystemArray[i] = generalEnvelope.getCoordinateReferenceSystem();
            if (referencingServices.setBounds(generalEnvelope, defaultGeographicBoundingBox, this.caller) == null) continue;
            if (var7_11 == null) {
                DefaultGeographicBoundingBox defaultGeographicBoundingBox2 = defaultGeographicBoundingBox;
                defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                continue;
            }
            this.reduce((DefaultGeographicBoundingBox)var7_11, defaultGeographicBoundingBox);
        }
        CoordinateReferenceSystem coordinateReferenceSystem = CRS.suggestCommonTarget((GeographicBoundingBox)var7_11, coordinateReferenceSystemArray);
        if (coordinateReferenceSystem == null) {
            throw new TransformException(Resources.format((short)82));
        }
        GeneralEnvelope generalEnvelope = null;
        for (int i = 0; i < n; ++i) {
            Envelope envelope = Envelopes.transform(generalEnvelopeArray[i], coordinateReferenceSystem);
            if (generalEnvelope == null) {
                generalEnvelope = GeneralEnvelope.castOrCopy(envelope);
                continue;
            }
            this.reduce(generalEnvelope, envelope);
        }
        return generalEnvelope;
    }
}

