/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.util.Arrays;
import org.apache.sis.internal.coverage.CompoundTransformOf1D;
import org.apache.sis.internal.coverage.RepeatedTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public abstract class CompoundTransform
extends AbstractMathTransform {
    private transient MathTransform inverse;

    CompoundTransform() {
    }

    abstract MathTransform[] components();

    public static MathTransform create(MathTransform[] mathTransformArray) {
        ArgumentChecks.ensureNonNull("components", mathTransformArray);
        int n = mathTransformArray.length;
        if (n == 0) {
            return MathTransforms.identity(0);
        }
        MathTransform mathTransform = mathTransformArray[0];
        ArgumentChecks.ensureNonNullElement("components", 0, mathTransform);
        if (n == 1) {
            return mathTransform;
        }
        if (ArraysExt.allEquals(mathTransformArray, mathTransform)) {
            return new RepeatedTransform(mathTransform, n);
        }
        MathTransform1D[] mathTransform1DArray = new MathTransform1D[n];
        for (int i = 0; i < n; ++i) {
            MathTransform mathTransform2 = mathTransformArray[i];
            ArgumentChecks.ensureNonNullElement("components", i, mathTransform2);
            if (!(mathTransform2 instanceof MathTransform1D)) {
                throw new UnsupportedOperationException("Non 1D-case not yet implemented.");
            }
            mathTransform1DArray[i] = (MathTransform1D)mathTransform2;
        }
        return new CompoundTransformOf1D(mathTransform1DArray);
    }

    @Override
    public int getSourceDimensions() {
        int n = 0;
        for (MathTransform mathTransform : this.components()) {
            n += mathTransform.getSourceDimensions();
        }
        return n;
    }

    @Override
    public int getTargetDimensions() {
        int n = 0;
        for (MathTransform mathTransform : this.components()) {
            n += mathTransform.getTargetDimensions();
        }
        return n;
    }

    @Override
    public boolean isIdentity() {
        for (MathTransform mathTransform : this.components()) {
            if (mathTransform.isIdentity()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            MathTransform[] mathTransformArray = this.components();
            MathTransform[] mathTransformArray2 = new MathTransform1D[mathTransformArray.length];
            for (int i = 0; i < mathTransformArray.length; ++i) {
                mathTransformArray2[i] = mathTransformArray[i].inverse();
            }
            this.inverse = CompoundTransform.create(mathTransformArray2);
        }
        return this.inverse;
    }

    @Override
    protected final MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        block5: {
            if (mathTransform instanceof CompoundTransform) {
                int n;
                MathTransform[] mathTransformArray = this.components();
                MathTransform[] mathTransformArray2 = ((CompoundTransform)mathTransform).components();
                if (mathTransformArray2.length == (n = mathTransformArray.length)) {
                    MathTransform[] mathTransformArray3 = new MathTransform1D[n];
                    for (int i = 0; i < n; ++i) {
                        MathTransform mathTransform2 = mathTransformArray[i];
                        MathTransform mathTransform3 = mathTransformArray2[i];
                        if (bl) {
                            mathTransform2 = mathTransform3;
                            mathTransform3 = mathTransformArray[i];
                        }
                        if (mathTransform2.getTargetDimensions() == mathTransform3.getSourceDimensions()) {
                            mathTransformArray3[i] = mathTransformFactory.createConcatenatedTransform(mathTransform2, mathTransform3);
                            continue;
                        }
                        break block5;
                    }
                    return CompoundTransform.create(mathTransformArray3);
                }
            }
        }
        return super.tryConcatenate(bl, mathTransform, mathTransformFactory);
    }

    @Override
    protected final int computeHashCode() {
        return super.hashCode() + Arrays.hashCode(this.components());
    }

    @Override
    public final boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        return super.equals(object, comparisonMode) && Utilities.deepEquals(this.components(), ((CompoundTransform)object).components(), comparisonMode);
    }
}

