/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.util.Arrays;
import org.apache.sis.internal.coverage.CompoundTransform;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class RepeatedTransform
extends CompoundTransform {
    private final MathTransform component;
    private final int repetition;

    RepeatedTransform(MathTransform mathTransform, int n) {
        this.component = mathTransform;
        this.repetition = n;
    }

    @Override
    final MathTransform[] components() {
        Object[] objectArray = new MathTransform[this.repetition];
        Arrays.fill(objectArray, this.component);
        return objectArray;
    }

    @Override
    public int getSourceDimensions() {
        return this.component.getSourceDimensions() * this.repetition;
    }

    @Override
    public int getTargetDimensions() {
        return this.component.getTargetDimensions() * this.repetition;
    }

    @Override
    public boolean isIdentity() {
        return this.component.isIdentity();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        MatrixSIS matrixSIS;
        if (bl) {
            matrixSIS = Matrices.createZero(this.repetition, this.repetition);
            for (int i = 0; i < this.repetition; ++i) {
                matrixSIS.setElement(i, i, ((MathTransform1D)this.component).derivative(dArray[n + i]));
            }
        } else {
            matrixSIS = null;
        }
        this.component.transform(dArray, n, dArray2, n2, this.repetition);
        return matrixSIS;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        this.component.transform(dArray, n, dArray2, n2, n3 * this.repetition);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        this.component.transform(fArray, n, fArray2, n2, n3 * this.repetition);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        this.component.transform(dArray, n, fArray, n2, n3 * this.repetition);
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        this.component.transform(fArray, n, dArray, n2, n3 * this.repetition);
    }
}

