/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.ScaledColorSpace;

public enum ColorModelType {
    DIRECT(false, false),
    INDEXED(true, false),
    SCALED(true, true),
    OTHER(false, true);

    public final boolean useColorRamp;
    public final boolean isSlow;

    private ColorModelType(boolean bl, boolean bl2) {
        this.useColorRamp = bl;
        this.isSlow = bl2;
    }

    public static ColorModelType find(ColorModel colorModel) {
        if (colorModel != null) {
            if (colorModel instanceof DirectColorModel) {
                return DIRECT;
            }
            if (colorModel instanceof IndexColorModel) {
                return INDEXED;
            }
            if (colorModel.getColorSpace() instanceof ScaledColorSpace) {
                return SCALED;
            }
            if (colorModel.getClass() == ComponentColorModel.class && colorModel.getColorSpace().getType() == 5 && ImageUtilities.isIntegerType(colorModel.getTransferType())) {
                return DIRECT;
            }
        }
        return OTHER;
    }
}

