/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Arrays;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;

public final class SampleModelFactory {
    private int dataType;
    private final int width;
    private final int height;
    private int numBands;
    private int[] bankIndices;
    private int[] bandOffsets;
    private int[] bitMasks;
    private int dataBitOffset;
    private int numberOfBits;
    private int pixelStride;
    private int scanlineStride;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SampleModelFactory(DataType dataType, int n, int n2, int n3, int n4, boolean bl) {
        this.dataType = dataType.toDataBufferType();
        this.width = n;
        this.height = n2;
        this.numBands = n3;
        this.scanlineStride = n;
        this.pixelStride = 1;
        if (n4 != dataType.size()) {
            if (n3 == 1) {
                this.pixelStride = 0;
                this.numberOfBits = n4;
                this.scanlineStride = Numerics.ceilDiv(Math.multiplyExact(n, this.numberOfBits), dataType.size());
                return;
            } else {
                if (bl) throw new RasterFormatException(Errors.format((short)163, "bitsPerSample=" + dataType.size()));
                this.bitMasks = new int[n3];
                this.bitMasks[0] = (1 << n4) - 1;
                for (int i = 1; i < this.bitMasks.length; ++i) {
                    this.bitMasks[i] = this.bitMasks[i - 1] << n4;
                }
            }
            return;
        } else if (bl) {
            this.bankIndices = ArraysExt.range(0, n3);
            this.bandOffsets = new int[n3];
            return;
        } else {
            this.bandOffsets = ArraysExt.range(0, n3);
            this.scanlineStride = Math.multiplyExact(n3, n);
            this.pixelStride = n3;
        }
    }

    public SampleModelFactory(SampleModel sampleModel) {
        this.width = sampleModel.getWidth();
        this.height = sampleModel.getHeight();
        this.numBands = sampleModel.getNumBands();
        this.dataType = sampleModel.getDataType();
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            this.bankIndices = componentSampleModel.getBankIndices();
            this.bandOffsets = componentSampleModel.getBandOffsets();
            this.scanlineStride = componentSampleModel.getScanlineStride();
            this.pixelStride = componentSampleModel.getPixelStride();
            for (int i = 0; i < this.bankIndices.length; ++i) {
                if (this.bankIndices[i] == 0) continue;
                return;
            }
            this.bankIndices = null;
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            this.bitMasks = singlePixelPackedSampleModel.getBitMasks();
            this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
            this.pixelStride = 1;
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            this.numberOfBits = multiPixelPackedSampleModel.getPixelBitStride();
            this.dataBitOffset = multiPixelPackedSampleModel.getDataBitOffset();
            this.scanlineStride = multiPixelPackedSampleModel.getScanlineStride();
        } else {
            throw new RasterFormatException(Errors.format((short)163, sampleModel.getClass()));
        }
    }

    public void subsetAndCompress(int[] nArray) {
        ArgumentChecks.ensureSizeBetween("bands", 1, this.numBands, nArray.length);
        if (this.bankIndices != null) {
            this.bankIndices = SampleModelFactory.subset(this.bankIndices, nArray, true);
        }
        if (this.bandOffsets != null) {
            this.bandOffsets = SampleModelFactory.subset(this.bandOffsets, nArray, this.bankIndices == null);
        }
        if (this.bitMasks != null) {
            int n;
            int[] nArray2 = new int[this.bitMasks.length];
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = SampleModelFactory.bitCount(this.bitMasks[n]);
            }
            for (n = 0; n < nArray.length; ++n) {
                nArray2[nArray[n]] = 0;
            }
            for (n = 1; n < nArray2.length; ++n) {
                int n2 = n;
                nArray2[n2] = nArray2[n2] + nArray2[n - 1];
            }
            int[] nArray3 = new int[nArray.length];
            int n3 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = nArray[i];
                nArray3[i] = this.bitMasks[n4] >>> nArray2[n4];
                n3 |= nArray3[i];
            }
            this.bitMasks = nArray3;
            if (this.dataType == 3 && (n3 & 0xFFFF0000) == 0) {
                this.dataType = 1;
            }
            if (this.dataType == 1 && (n3 & 0xFFFFFF00) == 0) {
                this.dataType = 0;
            }
        }
        if (this.pixelStride > 1) {
            int n = this.scanlineStride / this.pixelStride;
            int n5 = this.scanlineStride % this.pixelStride;
            this.pixelStride -= this.numBands - nArray.length;
            this.scanlineStride = this.pixelStride * n + n5;
        }
        this.numBands = nArray.length;
    }

    private static int bitCount(int n) {
        return 32 - Integer.numberOfLeadingZeros(n) - Integer.numberOfTrailingZeros(n);
    }

    private static int[] subset(int[] nArray, int[] nArray2, boolean bl) {
        int[] nArray3 = new int[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        if (!bl) {
            return nArray3;
        }
        Arrays.sort(nArray3);
        int[] nArray4 = new int[nArray3.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray4[i] = Arrays.binarySearch(nArray3, nArray[nArray2[i]]);
            assert (nArray4[i] >= 0);
        }
        return nArray4;
    }

    public SampleModel build() {
        if (this.pixelStride == 1) {
            if (this.bankIndices != null) {
                return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, this.bankIndices, this.bandOffsets);
            }
            if (this.bitMasks != null) {
                return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, this.bitMasks);
            }
        }
        if (this.numberOfBits != 0) {
            return new MultiPixelPackedSampleModel(this.dataType, this.width, this.height, this.numberOfBits, this.scanlineStride, this.dataBitOffset);
        }
        return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, this.bandOffsets);
    }
}

