/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.distribution.Format;

public enum Capability {
    READ(166),
    WRITE(226),
    CREATE(40);

    private final short resourceKey;

    private Capability(short s2) {
        this.resourceKey = s2;
    }

    public static String[] providers(Locale locale, Vocabulary vocabulary) {
        Collection<DataStoreProvider> collection = DataStores.providers();
        int n = collection.size();
        String[] stringArray = new String[n * 2];
        int n2 = 0;
        for (DataStoreProvider dataStoreProvider : collection) {
            String string;
            String string2;
            StoreMetadata storeMetadata = dataStoreProvider.getClass().getAnnotation(StoreMetadata.class);
            String string3 = null;
            if (storeMetadata != null) {
                for (Capability capability : storeMetadata.capabilities()) {
                    String string4 = vocabulary.getString(capability.resourceKey);
                    string3 = string3 == null ? string4 : vocabulary.getString((short)181, string3, string4.toLowerCase(locale));
                }
            }
            if (string3 == null) {
                string3 = vocabulary.getString((short)207);
            }
            Format format = dataStoreProvider.getFormat();
            try {
                string2 = Types.toString(format.getSpecification(), locale);
                if (string2 == null) {
                    string2 = Types.toString(format.getName(), locale);
                }
                string = dataStoreProvider.getShortName();
            }
            catch (BackingStoreException backingStoreException) {
                string2 = dataStoreProvider.getShortName();
                string = Exceptions.getLocalizedMessage(Exceptions.unwrap(backingStoreException), locale);
            }
            if (string != null && !string.equals(string2)) {
                string2 = vocabulary.getString((short)158, string2, string);
            }
            stringArray[n2++] = string3;
            stringArray[n2++] = string2;
        }
        return stringArray;
    }
}

