/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.folder;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.folder.Store;
import org.apache.sis.internal.storage.folder.WritableStore;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

@StoreMetadata(formatName="folder", capabilities={Capability.READ, Capability.WRITE}, resourceTypes={Aggregate.class, FeatureSet.class, GridCoverageResource.class}, yieldPriority=true)
public final class StoreProvider
extends DataStoreProvider {
    static final String NAME = "folder";
    private static final ParameterDescriptor<Locale> LOCALE;
    private static final ParameterDescriptor<TimeZone> TIMEZONE;
    private static final ParameterDescriptor<Charset> ENCODING;
    private static final ParameterDescriptor<String> FORMAT;
    static final ParameterDescriptorGroup PARAMETERS;

    private static <T> ParameterDescriptor<T> annotate(ParameterBuilder parameterBuilder, ParameterDescriptor<T> parameterDescriptor, InternationalString internationalString) {
        return ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName(parameterDescriptor.getName())).setDescription(((DefaultParameterDescriptor)parameterDescriptor).getDescription())).setRemarks(internationalString)).create(parameterDescriptor.getValueClass(), null);
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return PARAMETERS;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        try {
            Path path = storageConnector.getStorageAs(Path.class);
            if (path != null && Files.isDirectory(path, new LinkOption[0])) {
                return ProbeResult.SUPPORTED;
            }
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            Logging.recoverableException(this.getLogger(), StoreProvider.class, "probeContent", fileSystemNotFoundException);
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return this.open(storageConnector, null, EnumSet.noneOf(StandardOpenOption.class));
    }

    private DataStore open(StorageConnector storageConnector, String string, EnumSet<StandardOpenOption> enumSet) throws DataStoreException {
        Store store;
        DataStoreProvider dataStoreProvider;
        if (string != null) {
            dataStoreProvider = StoreUtilities.providerByFormatName(string.trim());
            if (Boolean.FALSE.equals(StoreUtilities.canWrite(dataStoreProvider.getClass()))) {
                enumSet.clear();
            }
        } else {
            dataStoreProvider = null;
            enumSet.clear();
        }
        Path path = storageConnector.getStorageAs(Path.class);
        try {
            boolean bl = false;
            if (enumSet.contains(StandardOpenOption.CREATE) && (enumSet.contains(StandardOpenOption.CREATE_NEW) || Files.notExists(path, new LinkOption[0]))) {
                Files.createDirectory(path, new FileAttribute[0]);
                bl = true;
            }
            store = bl || enumSet.contains(StandardOpenOption.WRITE) && Files.isWritable(path) ? new WritableStore(this, storageConnector, path, dataStoreProvider) : new Store(this, storageConnector, path, dataStoreProvider);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new DataStoreException(Resources.format((short)44, path));
            }
            if (enumSet.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
                WritableStore.deleteRecursively(path, false);
            }
        }
        catch (IOException iOException) {
            short s2;
            int n = 0;
            if (iOException instanceof FileAlreadyExistsException) {
                if (path != null && Files.isDirectory(path, new LinkOption[0])) {
                    n = 1;
                }
                s2 = 45;
            } else {
                s2 = iOException instanceof NoSuchFileException ? (short)46 : 43;
            }
            throw new DataStoreException(Resources.format(s2, path != null ? path : storageConnector.getStorageName(), n), iOException);
        }
        storageConnector.closeAllExcept(path);
        return store;
    }

    @Override
    public DataStore open(ParameterValueGroup parameterValueGroup) throws DataStoreException {
        ArgumentChecks.ensureNonNull("parameter", parameterValueGroup);
        StorageConnector storageConnector = URIDataStore.Provider.connector(this, parameterValueGroup);
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        storageConnector.setOption(OptionKey.LOCALE, parameters.getValue(LOCALE));
        storageConnector.setOption(OptionKey.TIMEZONE, parameters.getValue(TIMEZONE));
        storageConnector.setOption(OptionKey.ENCODING, parameters.getValue(ENCODING));
        EnumSet<StandardOpenOption> enumSet = EnumSet.of(StandardOpenOption.WRITE);
        if (Boolean.TRUE.equals(parameters.getValue(URIDataStore.Provider.CREATE_PARAM))) {
            enumSet.add(StandardOpenOption.CREATE);
        }
        return this.open(storageConnector, parameters.getValue(FORMAT), enumSet);
    }

    static {
        ParameterBuilder parameterBuilder = new ParameterBuilder();
        InternationalString internationalString = Resources.formatInternational((short)33);
        ENCODING = StoreProvider.annotate(parameterBuilder, URIDataStore.Provider.ENCODING, internationalString);
        LOCALE = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName("locale")).setDescription(Resources.formatInternational((short)30))).setRemarks(internationalString)).create(Locale.class, null);
        TIMEZONE = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName("timezone")).setDescription(Resources.formatInternational((short)32))).setRemarks(internationalString)).create(TimeZone.class, null);
        FORMAT = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName("format")).setDescription(Resources.formatInternational((short)40))).create(String.class, null);
        ParameterDescriptor<Object> parameterDescriptor = new ParameterBuilder(URIDataStore.Provider.LOCATION_PARAM).create(Path.class, null);
        PARAMETERS = ((ParameterBuilder)parameterBuilder.addName(NAME)).createGroup(parameterDescriptor, LOCALE, TIMEZONE, ENCODING, FORMAT, URIDataStore.Provider.CREATE_PARAM);
    }
}

