/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.DerivedScalar;
import org.apache.sis.measure.Scalar;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.measure.ScalarFallback;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class Quantities
extends Static {
    private Quantities() {
    }

    public static Quantity<?> create(double d, String string) {
        return Quantities.create(d, Units.valueOf(string));
    }

    public static <Q extends Quantity<Q>> Q create(double d, Unit<Q> unit) {
        ArgumentChecks.ensureNonNull("unit", unit);
        Unit<Q> unit2 = unit.getSystemUnit();
        if (unit2 instanceof SystemUnit) {
            Class clazz;
            UnitConverter unitConverter = unit.getConverterTo(unit2);
            ScalarFactory<Q> scalarFactory = ((SystemUnit)unit2).factory;
            if (unitConverter.isLinear()) {
                if (scalarFactory != null) {
                    return scalarFactory.create(d, unit);
                }
                Class clazz2 = ((SystemUnit)unit2).quantity;
                if (clazz2 != null) {
                    return ScalarFallback.factory(d, unit, clazz2);
                }
                Scalar<Q> scalar = new Scalar<Q>(d, unit);
                return (Q)scalar;
            }
            if (scalarFactory != null && (clazz = scalarFactory.createDerived(d, unit, unit2, unitConverter)) != null) {
                return (Q)clazz;
            }
            clazz = ((SystemUnit)unit2).quantity;
            if (clazz != null) {
                return DerivedScalar.Fallback.factory(d, unit, unit2, unitConverter, clazz);
            }
            DerivedScalar<Q> derivedScalar = new DerivedScalar<Q>(d, unit, unit2, unitConverter);
            return (Q)derivedScalar;
        }
        throw new IllegalArgumentException(Errors.format((short)160, unit.getClass()));
    }

    public static <Q extends Quantity<Q>> Q castOrCopy(Quantity<Q> quantity) {
        if (quantity != null) {
            Unit<Q> unit = quantity.getUnit();
            Unit<Q> unit2 = unit.getSystemUnit();
            if (!(unit2 instanceof SystemUnit)) {
                throw new IllegalArgumentException(Errors.format((short)160, unit.getClass()));
            }
            Class clazz = ((SystemUnit)unit2).quantity;
            if (!clazz.isInstance(quantity)) {
                ScalarFactory<Q> scalarFactory = ((SystemUnit)unit2).factory;
                double d = AbstractConverter.doubleValue(quantity.getValue());
                if (scalarFactory != null) {
                    return scalarFactory.create(d, unit);
                }
                return ScalarFallback.factory(d, unit, clazz);
            }
        }
        return (Q)quantity;
    }

    public static <Q extends Quantity<Q>> Quantity<Q> min(Quantity<Q> quantity, Quantity<Q> quantity2) {
        return Quantities.minOrMax(quantity, quantity2, false);
    }

    public static <Q extends Quantity<Q>> Quantity<Q> max(Quantity<Q> quantity, Quantity<Q> quantity2) {
        return Quantities.minOrMax(quantity, quantity2, true);
    }

    private static <Q extends Quantity<Q>> Quantity<Q> minOrMax(Quantity<Q> quantity, Quantity<Q> quantity2, boolean bl) {
        Unit<Q> unit;
        if (quantity == null) {
            return quantity2;
        }
        if (quantity2 == null) {
            return quantity;
        }
        Unit<Q> unit2 = quantity.getUnit();
        Unit<Q> unit3 = quantity2.getUnit();
        Unit<Q> unit4 = unit2.getSystemUnit();
        if (!Objects.equals(unit4, unit = unit3.getSystemUnit())) {
            throw new UnconvertibleException((String)null);
        }
        Number number = unit2.getConverterTo(unit4).convert(quantity.getValue());
        Number number2 = unit3.getConverterTo(unit).convert(quantity2.getValue());
        if (Numbers.isNaN(number2)) {
            return quantity;
        }
        if (Numbers.isNaN(number)) {
            return quantity2;
        }
        int n = Quantities.compare(number, number2);
        return (bl ? n >= 0 : n <= 0) ? quantity : quantity2;
    }

    private static int compare(Number number, Number number2) {
        if (number instanceof Comparable) {
            if (number.getClass().isInstance(number2)) {
                return ((Comparable)((Object)number)).compareTo(number2);
            }
            if (number2 instanceof Comparable && number2.getClass().isInstance(number)) {
                return -((Comparable)((Object)number2)).compareTo(number);
            }
        }
        return Double.compare(number.doubleValue(), number2.doubleValue());
    }
}

