/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import java.util.function.BiConsumer;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.metadata.CI_Citation;
import org.apache.sis.internal.jaxb.metadata.MD_Medium;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.Medium;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Format_Type", propOrder={"name", "version", "amendmentNumber", "specification", "formatSpecificationCitation", "fileDecompressionTechnique", "media", "formatDistributors"})
@XmlRootElement(name="MD_Format")
public class DefaultFormat
extends ISOMetadata
implements Format {
    private static final long serialVersionUID = -8346373589075887348L;
    private Citation formatSpecificationCitation;
    private InternationalString amendmentNumber;
    private InternationalString fileDecompressionTechnique;
    private Collection<Medium> media;
    private Collection<Distributor> formatDistributors;

    public DefaultFormat() {
    }

    public DefaultFormat(Format format) {
        super(format);
        if (format != null) {
            this.amendmentNumber = format.getAmendmentNumber();
            this.fileDecompressionTechnique = format.getFileDecompressionTechnique();
            this.formatDistributors = this.copyCollection(format.getFormatDistributors(), Distributor.class);
            if (format instanceof DefaultFormat) {
                this.formatSpecificationCitation = ((DefaultFormat)format).getFormatSpecificationCitation();
                this.media = this.copyCollection(((DefaultFormat)format).getMedia(), Medium.class);
            } else {
                this.setSpecification(format.getSpecification());
                this.setVersion(format.getVersion());
                this.setName(format.getName());
            }
        }
    }

    public static DefaultFormat castOrCopy(Format format) {
        if (format == null || format instanceof DefaultFormat) {
            return (DefaultFormat)format;
        }
        return new DefaultFormat(format);
    }

    @XmlElement(name="formatSpecificationCitation", required=true)
    @XmlJavaTypeAdapter(value=CI_Citation.Since2014.class)
    @UML(identifier="formatSpecificationCitation", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Citation getFormatSpecificationCitation() {
        return this.formatSpecificationCitation;
    }

    public void setFormatSpecificationCitation(Citation citation) {
        this.checkWritePermission(this.formatSpecificationCitation);
        this.formatSpecificationCitation = citation;
    }

    private <T> void setFormatSpecificationCitation(BiConsumer<DefaultCitation, T> biConsumer, T t2) {
        Citation citation = this.formatSpecificationCitation;
        if (citation != null || t2 != null) {
            if (!(citation instanceof DefaultCitation)) {
                citation = new DefaultCitation(citation);
            }
            biConsumer.accept((DefaultCitation)citation, (DefaultCitation)t2);
            if (t2 == null && ((DefaultCitation)citation).isEmpty()) {
                citation = null;
            }
        }
        if (citation != this.formatSpecificationCitation) {
            this.setFormatSpecificationCitation(citation);
        }
    }

    @Override
    @Deprecated
    @Dependencies(value={"getFormatSpecificationCitation"})
    @XmlElement(name="specification", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getSpecification() {
        Citation citation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (citation = this.getFormatSpecificationCitation()) != null) {
            return citation.getTitle();
        }
        return null;
    }

    @Deprecated
    public void setSpecification(InternationalString internationalString2) {
        this.checkWritePermission(this.formatSpecificationCitation);
        this.setFormatSpecificationCitation((defaultCitation, internationalString) -> defaultCitation.setTitle((InternationalString)internationalString), internationalString2);
    }

    @Override
    @Deprecated
    @Dependencies(value={"getFormatSpecificationCitation"})
    @XmlElement(name="name", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getName() {
        Citation citation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (citation = this.getFormatSpecificationCitation()) != null) {
            return LegacyPropertyAdapter.getSingleton(citation.getAlternateTitles(), InternationalString.class, null, DefaultFormat.class, "getName");
        }
        return null;
    }

    @Deprecated
    public void setName(InternationalString internationalString2) {
        this.checkWritePermission(this.formatSpecificationCitation);
        this.setFormatSpecificationCitation((defaultCitation, internationalString) -> defaultCitation.setAlternateTitles(CollectionsExt.singletonOrEmpty(internationalString)), internationalString2);
    }

    @Override
    @Deprecated
    @Dependencies(value={"getFormatSpecificationCitation"})
    @XmlElement(name="version", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getVersion() {
        Citation citation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (citation = this.getFormatSpecificationCitation()) != null) {
            return citation.getEdition();
        }
        return null;
    }

    @Deprecated
    public void setVersion(InternationalString internationalString2) {
        this.checkWritePermission(this.formatSpecificationCitation);
        this.setFormatSpecificationCitation((defaultCitation, internationalString) -> defaultCitation.setEdition((InternationalString)internationalString), internationalString2);
    }

    @Override
    @XmlElement(name="amendmentNumber")
    public InternationalString getAmendmentNumber() {
        return this.amendmentNumber;
    }

    public void setAmendmentNumber(InternationalString internationalString) {
        this.checkWritePermission(this.amendmentNumber);
        this.amendmentNumber = internationalString;
    }

    @Override
    @XmlElement(name="fileDecompressionTechnique")
    public InternationalString getFileDecompressionTechnique() {
        return this.fileDecompressionTechnique;
    }

    public void setFileDecompressionTechnique(InternationalString internationalString) {
        this.checkWritePermission(this.fileDecompressionTechnique);
        this.fileDecompressionTechnique = internationalString;
    }

    @XmlElement(name="medium")
    @XmlJavaTypeAdapter(value=MD_Medium.Since2014.class)
    @UML(identifier="medium", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Medium> getMedia() {
        this.media = this.nonNullCollection(this.media, Medium.class);
        return this.media;
    }

    public void setMedia(Collection<? extends Medium> collection) {
        this.media = this.writeCollection(collection, this.media, Medium.class);
    }

    @XmlElement(name="formatDistributor")
    public Collection<Distributor> getFormatDistributors() {
        this.formatDistributors = this.nonNullCollection(this.formatDistributors, Distributor.class);
        return this.formatDistributors;
    }

    public void setFormatDistributors(Collection<? extends Distributor> collection) {
        this.formatDistributors = this.writeCollection(collection, this.formatDistributors, Distributor.class);
    }
}

