/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

@XmlType(name="EllipsoidalCSType")
@XmlRootElement(name="EllipsoidalCS")
public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;

    private DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
        this.validateAxes(map);
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2);
        this.validateAxes(map);
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        this.validateAxes(map);
    }

    protected DefaultEllipsoidalCS(EllipsoidalCS ellipsoidalCS) {
        super(ellipsoidalCS);
    }

    public static DefaultEllipsoidalCS castOrCopy(EllipsoidalCS ellipsoidalCS) {
        return ellipsoidalCS == null || ellipsoidalCS instanceof DefaultEllipsoidalCS ? (DefaultEllipsoidalCS)ellipsoidalCS : new DefaultEllipsoidalCS(ellipsoidalCS);
    }

    @Override
    final int validateAxis(AxisDirection axisDirection, Unit<?> unit) {
        boolean bl = AxisDirection.UP.equals(axisDirection = AxisDirections.absolute(axisDirection));
        if (!(bl || AxisDirection.NORTH.equals(axisDirection) || AxisDirection.EAST.equals(axisDirection))) {
            return 1;
        }
        if (!(!bl ? Units.isAngular(unit) : Units.isLinear(unit))) {
            return 2;
        }
        return 0;
    }

    private void validateAxes(Map<String, ?> map) {
        int n = super.getDimension();
        int n2 = n - 2;
        while (--n >= 0) {
            AxisDirection axisDirection = super.getAxis(n).getDirection();
            if (!AxisDirections.isVertical(axisDirection) || --n2 >= 0) continue;
            throw new IllegalArgumentException(Resources.forProperties(map).getString((short)20, EllipsoidalCS.class, axisDirection));
        }
    }

    public Class<? extends EllipsoidalCS> getInterface() {
        return EllipsoidalCS.class;
    }

    @Override
    public DefaultEllipsoidalCS forConvention(AxesConvention axesConvention) {
        return (DefaultEllipsoidalCS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        switch (coordinateSystemAxisArray.length) {
            case 1: {
                return new DefaultVerticalCS(map, coordinateSystemAxisArray);
            }
            case 2: 
            case 3: {
                return new DefaultEllipsoidalCS(map, coordinateSystemAxisArray);
            }
        }
        throw DefaultEllipsoidalCS.unexpectedDimension(map, coordinateSystemAxisArray, 1);
    }

    private DefaultEllipsoidalCS() {
    }
}

