/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

final class IdentityTransform
extends AbstractLinearTransform {
    private static final long serialVersionUID = -5339040282922138164L;
    private static final LinearTransform[] IDENTITIES = new LinearTransform[8];
    private final int dimension;

    private IdentityTransform(int n) {
        this.dimension = n;
        this.inverse = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinearTransform create(int n) {
        LinearTransform[] linearTransformArray = IDENTITIES;
        synchronized (IDENTITIES) {
            LinearTransform linearTransform;
            if (n < IDENTITIES.length && (linearTransform = IDENTITIES[n]) != null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return linearTransform;
            }
            switch (n) {
                default: {
                    linearTransform = new IdentityTransform(n);
                    break;
                }
                case 1: {
                    linearTransform = IdentityTransform1D.INSTANCE;
                    break;
                }
                case 2: {
                    linearTransform = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
                }
            }
            if (n < IDENTITIES.length) {
                IdentityTransform.IDENTITIES[n] = linearTransform;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return linearTransform;
        }
    }

    @Override
    public boolean isAffine() {
        return true;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public double getElement(int n, int n2) {
        return n == n2 ? 1.0 : 0.0;
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        return Matrices.createIdentity(this.dimension);
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) {
        ArgumentChecks.ensureDimensionMatches("ptSrc", this.dimension, directPosition);
        if (directPosition2 == null) {
            return new GeneralDirectPosition(directPosition);
        }
        ArgumentChecks.ensureDimensionMatches("ptDst", this.dimension, directPosition2);
        for (int i = 0; i < this.dimension; ++i) {
            directPosition2.setOrdinate(i, directPosition.getOrdinate(i));
        }
        return directPosition2;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        if (dArray2 != null) {
            System.arraycopy(dArray, n, dArray2, n2, this.dimension);
        }
        return bl ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        System.arraycopy(dArray, n, dArray2, n2, n3 * this.dimension);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        System.arraycopy(fArray, n, fArray2, n2, n3 * this.dimension);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        n3 *= this.dimension;
        while (--n3 >= 0) {
            fArray[n2++] = (float)dArray[n++];
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        n3 *= this.dimension;
        while (--n3 >= 0) {
            dArray[n2++] = fArray[n++];
        }
    }

    @Override
    public LinearTransform inverse() {
        return this;
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        return ((IdentityTransform)object).dimension == this.dimension;
    }
}

