/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.OptionalLong;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.FeatureExpression;
import org.apache.sis.internal.filter.SortByComparator;
import org.apache.sis.internal.geoapi.filter.Literal;
import org.apache.sis.internal.geoapi.filter.SortBy;
import org.apache.sis.internal.geoapi.filter.SortProperty;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.FeatureSubset;
import org.apache.sis.storage.Query;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.util.GenericName;

public class FeatureQuery
extends Query
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5841189659773611160L;
    private static final long UNLIMITED = -1L;
    private NamedExpression[] projection;
    private Filter<? super AbstractFeature> selection;
    private long skip;
    private long limit = -1L;
    private SortBy<AbstractFeature> sortBy;
    private Quantity<Length> linearResolution;

    @Override
    public void setProjection(String ... stringArray) {
        NamedExpression[] namedExpressionArray = null;
        if (stringArray != null) {
            DefaultFilterFactory<AbstractFeature, Object, Object> defaultFilterFactory = DefaultFilterFactory.forFeatures();
            namedExpressionArray = new NamedExpression[stringArray.length];
            for (int i = 0; i < namedExpressionArray.length; ++i) {
                String string = stringArray[i];
                ArgumentChecks.ensureNonNullElement("properties", i, string);
                namedExpressionArray[i] = new NamedExpression(defaultFilterFactory.property(string));
            }
        }
        this.setProjection(namedExpressionArray);
    }

    @SafeVarargs
    public final void setProjection(Expression<? super AbstractFeature, ?> ... expressionArray) {
        NamedExpression[] namedExpressionArray = null;
        if (expressionArray != null) {
            namedExpressionArray = new NamedExpression[expressionArray.length];
            for (int i = 0; i < namedExpressionArray.length; ++i) {
                Expression<? super AbstractFeature, ?> expression = expressionArray[i];
                ArgumentChecks.ensureNonNullElement("properties", i, expression);
                namedExpressionArray[i] = new NamedExpression(expression);
            }
        }
        this.setProjection(namedExpressionArray);
    }

    public void setProjection(NamedExpression ... namedExpressionArray) {
        if (namedExpressionArray != null) {
            ArgumentChecks.ensureNonEmpty("properties", namedExpressionArray);
            namedExpressionArray = (NamedExpression[])namedExpressionArray.clone();
            LinkedHashMap<Object, Integer> linkedHashMap = new LinkedHashMap<Object, Integer>(Containers.hashMapCapacity(namedExpressionArray.length));
            for (int i = 0; i < namedExpressionArray.length; ++i) {
                NamedExpression namedExpression = namedExpressionArray[i];
                ArgumentChecks.ensureNonNullElement("properties", i, namedExpression);
                Object object = namedExpression.alias != null ? namedExpression.alias : namedExpression.expression;
                Integer n = linkedHashMap.putIfAbsent(object, i);
                if (n == null) continue;
                if (object instanceof Expression) {
                    object = FeatureQuery.label((Expression)object);
                }
                throw new IllegalArgumentException(Resources.format((short)54, object, n, i));
            }
        }
        this.projection = namedExpressionArray;
    }

    public NamedExpression[] getProjection() {
        return this.projection != null ? (NamedExpression[])this.projection.clone() : null;
    }

    @Override
    public void setSelection(Envelope envelope) {
        Filter<AbstractFeature> filter = null;
        if (envelope != null) {
            DefaultFilterFactory<AbstractFeature, Object, Object> defaultFilterFactory = DefaultFilterFactory.forFeatures();
            filter = defaultFilterFactory.bbox(defaultFilterFactory.property("sis:geometry"), envelope);
        }
        this.setSelection(filter);
    }

    public void setSelection(Filter<? super AbstractFeature> filter) {
        this.selection = filter;
    }

    public Filter<? super AbstractFeature> getSelection() {
        return this.selection;
    }

    public void setOffset(long l) {
        ArgumentChecks.ensurePositive("skip", l);
        this.skip = l;
    }

    public long getOffset() {
        return this.skip;
    }

    public void setUnlimited() {
        this.limit = -1L;
    }

    public void setLimit(long l) {
        ArgumentChecks.ensurePositive("limit", l);
        this.limit = l;
    }

    public OptionalLong getLimit() {
        return this.limit >= 0L ? OptionalLong.of(this.limit) : OptionalLong.empty();
    }

    @SafeVarargs
    final void setSortBy(SortProperty<AbstractFeature> ... sortPropertyArray) {
        SortByComparator<AbstractFeature> sortByComparator = null;
        if (sortPropertyArray != null) {
            sortByComparator = SortByComparator.create(sortPropertyArray);
        }
        this.setSortBy(sortByComparator);
    }

    final void setSortBy(SortBy<AbstractFeature> sortBy) {
        this.sortBy = sortBy;
    }

    final SortBy<AbstractFeature> getSortBy() {
        return this.sortBy;
    }

    public void setLinearResolution(Quantity<Length> quantity) {
        this.linearResolution = quantity;
    }

    public Quantity<Length> getLinearResolution() {
        return this.linearResolution;
    }

    private static String label(Expression<?, ?> expression) {
        String string;
        if (expression instanceof Literal) {
            string = String.valueOf(((Literal)expression).getValue());
        } else if (expression instanceof ValueReference) {
            string = ((ValueReference)expression).getXPath();
        } else {
            return expression.getFunctionName().toString();
        }
        return CharSequences.shortSentence(string, 40).toString();
    }

    protected FeatureSet execute(FeatureSet featureSet) throws DataStoreException {
        ArgumentChecks.ensureNonNull("source", featureSet);
        FeatureQuery featureQuery = this.clone();
        if (featureQuery.selection != null) {
            Optimization optimization = new Optimization();
            optimization.setFeatureType(featureSet.getType());
            featureQuery.selection = optimization.apply(featureQuery.selection);
        }
        return new FeatureSubset(featureSet, featureQuery);
    }

    final DefaultFeatureType expectedType(DefaultFeatureType defaultFeatureType) {
        if (this.projection == null) {
            return defaultFeatureType;
        }
        int n = 0;
        HashSet<String> hashSet = null;
        FeatureTypeBuilder featureTypeBuilder = new FeatureTypeBuilder().setName(defaultFeatureType.getName());
        for (int i = 0; i < this.projection.length; ++i) {
            PropertyTypeBuilder propertyTypeBuilder;
            GenericName genericName = this.projection[i].alias;
            Expression<AbstractFeature, ?> expression = this.projection[i].expression;
            FeatureExpression<? super AbstractFeature, ? super AbstractFeature> featureExpression = FeatureExpression.castOrCopy(expression);
            if (featureExpression == null || (propertyTypeBuilder = featureExpression.expectedType(defaultFeatureType, featureTypeBuilder)) == null) {
                throw new IllegalArgumentException(Resources.format((short)60, expression.getFunctionName().toInternationalString(), i));
            }
            if (genericName == null) {
                if (hashSet == null) {
                    hashSet = new HashSet<String>(Containers.hashMapCapacity(this.projection.length));
                    for (NamedExpression namedExpression : this.projection) {
                        if (namedExpression.alias == null) continue;
                        hashSet.add(namedExpression.alias.toString());
                    }
                }
                Object object = null;
                if (expression instanceof ValueReference) {
                    GenericName genericName2 = propertyTypeBuilder.getName();
                    if (genericName2 != null && hashSet.add(genericName2.toString())) continue;
                    String string = ((ValueReference)expression).getXPath().trim();
                    if (!(string = string.substring(string.lastIndexOf(47) + 1)).isEmpty() && !hashSet.contains(string)) {
                        object = string;
                    }
                }
                if (object == null) {
                    while (!hashSet.add((object = Vocabulary.formatInternational((short)266, (Object)(++n))).toString())) {
                    }
                }
                genericName = Names.createLocalName(null, null, (CharSequence)object);
            }
            propertyTypeBuilder.setName(genericName);
        }
        return featureTypeBuilder.build();
    }

    public FeatureQuery clone() {
        try {
            return (FeatureQuery)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public int hashCode() {
        return 97 * Arrays.hashCode(this.projection) + 31 * Objects.hashCode(this.selection) + 7 * Objects.hashCode(this.sortBy) + Long.hashCode(this.limit ^ this.skip) + 3 * Objects.hashCode(this.linearResolution);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            FeatureQuery featureQuery = (FeatureQuery)object;
            return this.skip == featureQuery.skip && this.limit == featureQuery.limit && Objects.equals(this.selection, featureQuery.selection) && Arrays.equals(this.projection, featureQuery.projection) && Objects.equals(this.sortBy, featureQuery.sortBy) && Objects.equals(this.linearResolution, featureQuery.linearResolution);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("SELECT ");
        if (this.projection != null) {
            for (int i = 0; i < this.projection.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                this.projection[i].appendTo(stringBuilder);
            }
        } else {
            stringBuilder.append('*');
        }
        if (this.selection != null) {
            stringBuilder.append(" WHERE ").append(this.selection);
        }
        if (this.sortBy != null) {
            String string = " ORDER BY ";
            for (SortProperty<AbstractFeature> sortProperty : this.sortBy.getSortProperties()) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(sortProperty.getValueReference().getXPath()).append(' ').append((Object)sortProperty.getSortOrder());
            }
        }
        if (this.linearResolution != null) {
            stringBuilder.append(" RESOLUTION ").append(this.linearResolution);
        }
        if (this.limit != -1L) {
            stringBuilder.append(" LIMIT ").append(this.limit);
        }
        if (this.skip != 0L) {
            stringBuilder.append(" OFFSET ").append(this.skip);
        }
        return stringBuilder.toString();
    }

    public static class NamedExpression
    implements Serializable {
        private static final long serialVersionUID = -6919525113513842514L;
        public final Expression<? super AbstractFeature, ?> expression;
        public final GenericName alias;

        public NamedExpression(Expression<? super AbstractFeature, ?> expression) {
            ArgumentChecks.ensureNonNull("expression", expression);
            this.expression = expression;
            this.alias = null;
        }

        public NamedExpression(Expression<? super AbstractFeature, ?> expression, GenericName genericName) {
            ArgumentChecks.ensureNonNull("expression", expression);
            this.expression = expression;
            this.alias = genericName;
        }

        public NamedExpression(Expression<? super AbstractFeature, ?> expression, String string) {
            ArgumentChecks.ensureNonNull("expression", expression);
            this.expression = expression;
            this.alias = string != null ? Names.createLocalName(null, null, string) : null;
        }

        public int hashCode() {
            return 37 * this.expression.hashCode() + Objects.hashCode(this.alias);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                NamedExpression namedExpression = (NamedExpression)object;
                return this.expression.equals(namedExpression.expression) && Objects.equals(this.alias, namedExpression.alias);
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass().getSimpleName()).append('[');
            this.appendTo(stringBuilder);
            return stringBuilder.append(']').toString();
        }

        final void appendTo(StringBuilder stringBuilder) {
            if (this.expression instanceof Literal) {
                stringBuilder.append('\u201c').append(((Literal)this.expression).getValue()).append('\u201d');
            } else if (this.expression instanceof ValueReference) {
                stringBuilder.append(((ValueReference)this.expression).getXPath());
            } else {
                stringBuilder.append(this.expression.getFunctionName());
            }
            if (this.alias != null) {
                stringBuilder.append(" AS \u201c").append(this.alias).append('\u201d');
            }
        }
    }
}

