/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import thredds.catalog.ServiceType;
import thredds.catalog2.Service;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.GlobalServiceContainer;
import thredds.catalog2.simpleImpl.ServiceImpl;

class ServiceContainer {
    private List<ServiceImpl> services;
    private final GlobalServiceContainer globalServiceContainer;
    private boolean isBuilt;

    ServiceContainer(GlobalServiceContainer globalServiceContainer) {
        if (globalServiceContainer == null) {
            throw new IllegalArgumentException("");
        }
        this.isBuilt = false;
        this.globalServiceContainer = globalServiceContainer;
    }

    ServiceImpl getServiceByGloballyUniqueName(String name) {
        return this.globalServiceContainer.getServiceByGloballyUniqueName(name);
    }

    boolean isEmpty() {
        if (this.services == null) {
            return true;
        }
        return this.services.isEmpty();
    }

    int size() {
        if (this.services == null) {
            return 0;
        }
        return this.services.size();
    }

    ServiceImpl addService(String name, ServiceType type, URI baseUri) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceContainer has been built.");
        }
        if (this.services == null) {
            this.services = new ArrayList<ServiceImpl>();
        }
        ServiceImpl service = new ServiceImpl(name, type, baseUri, this.globalServiceContainer);
        boolean addedService = this.services.add(service);
        assert (addedService);
        this.globalServiceContainer.addService(service);
        return service;
    }

    boolean removeService(ServiceImpl service) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceContainer has been built.");
        }
        if (service == null) {
            return false;
        }
        if (this.services.remove(service)) {
            boolean success = this.globalServiceContainer.removeService(service);
            assert (success);
            return true;
        }
        return false;
    }

    List<Service> getServices() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder without being finished().");
        }
        if (this.services == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ServiceImpl>(this.services));
    }

    boolean containsServiceName(String name) {
        if (name == null) {
            return false;
        }
        if (this.services == null) {
            return false;
        }
        return null != this.getServiceImplByName(name);
    }

    Service getServiceByName(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder without being finished().");
        }
        if (name == null) {
            return null;
        }
        return this.getServiceImplByName(name);
    }

    private ServiceImpl getServiceImplByName(String name) {
        if (this.services != null) {
            for (ServiceImpl s2 : this.services) {
                if (!s2.getName().equals(name)) continue;
                return s2;
            }
        }
        return null;
    }

    List<ServiceBuilder> getServiceBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been finished().");
        }
        if (this.services == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ServiceImpl>(this.services));
    }

    ServiceBuilder getServiceBuilderByName(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been finished().");
        }
        if (name == null) {
            return null;
        }
        return this.getServiceImplByName(name);
    }

    boolean isBuilt() {
        return this.isBuilt;
    }

    BuilderIssues getIssues() {
        BuilderIssues issues = new BuilderIssues();
        if (this.services != null) {
            for (ServiceImpl sb : this.services) {
                issues.addAllIssues(sb.getIssues());
            }
        }
        return issues;
    }

    void build() throws BuilderException {
        if (this.isBuilt) {
            return;
        }
        if (this.services != null) {
            for (ServiceImpl sb : this.services) {
                sb.build();
            }
        }
        this.isBuilt = true;
    }
}

