/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;

final class GridCoordinatesView {
    private final long[] coordinates;
    private final int offset;

    GridCoordinatesView(long[] coordinates, int offset) {
        this.coordinates = coordinates;
        this.offset = offset;
    }

    public final int getDimension() {
        return this.coordinates.length >>> 1;
    }

    public final long[] getCoordinateValues() {
        return Arrays.copyOfRange(this.coordinates, this.offset, this.offset + this.getDimension());
    }

    public final long getCoordinateValue(int index) {
        ArgumentChecks.ensureValidIndex(this.getDimension(), index);
        return this.coordinates[this.offset + index];
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder("GridCoordinates[");
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(' ');
            }
            buffer.append(this.coordinates[i + this.offset]);
        }
        return buffer.append(']').toString();
    }

    public final int hashCode() {
        long code = -3L;
        int end = this.offset + this.getDimension();
        for (int i = this.offset; i < end; ++i) {
            code = 31L * code + this.coordinates[i];
        }
        return Long.hashCode(code);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridCoordinatesView) {
            GridCoordinatesView that = (GridCoordinatesView)object;
            return Arrays.equals(this.coordinates, this.offset, this.offset + this.getDimension(), that.coordinates, that.offset, that.offset + that.getDimension());
        }
        return false;
    }
}

