/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.QuantityFactory;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.Scalar;

class DefaultQuantityFactory<Q extends Quantity<Q>>
implements QuantityFactory<Q> {
    DefaultQuantityFactory() {
    }

    @Override
    public final Unit<Q> getSystemUnit() {
        return null;
    }

    @Override
    public Quantity<Q> create(Number value, Unit<Q> unit) {
        return new Scalar<Q>(AbstractConverter.doubleValue(value), unit);
    }

    @Override
    public final Quantity<Q> create(Number value, Unit<Q> unit, Quantity.Scale scale) {
        if (Objects.requireNonNull(scale) != Scalar.SCALE) {
            throw new UnsupportedOperationException("Relative scale is not yet supported.");
        }
        return this.create(value, unit);
    }
}

