/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.hsmf.parsers.POIFSChunkParser;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class OutlookExtractor {
    private static final Chunks CHUNKS = Chunks.getInstance((boolean)false);
    private final POIFSChunkParser parser;

    public OutlookExtractor(POIFSFileSystem filesystem) throws TikaException {
        try {
            this.parser = new POIFSChunkParser(filesystem);
        }
        catch (IOException e) {
            throw new TikaException("Failed to parse Outlook chunks", (Throwable)e);
        }
    }

    public void parse(XHTMLContentHandler xhtml, Metadata metadata) throws TikaException, SAXException {
        String subject = this.getChunk(OutlookExtractor.CHUNKS.subjectChunk);
        String from = this.getChunk(OutlookExtractor.CHUNKS.displayFromChunk);
        metadata.set("Author", from);
        metadata.set("title", subject);
        metadata.set("subject", this.getChunk(OutlookExtractor.CHUNKS.conversationTopic));
        xhtml.element("h1", subject);
        xhtml.startElement("dl");
        this.header(xhtml, "From", from);
        this.header(xhtml, "To", this.getChunk(OutlookExtractor.CHUNKS.displayToChunk));
        this.header(xhtml, "Cc", this.getChunk(OutlookExtractor.CHUNKS.displayCCChunk));
        this.header(xhtml, "Bcc", this.getChunk(OutlookExtractor.CHUNKS.displayBCCChunk));
        xhtml.endElement("dl");
        xhtml.element("p", this.getChunk(OutlookExtractor.CHUNKS.textBodyChunk));
    }

    private void header(XHTMLContentHandler xhtml, String key, String value) throws SAXException {
        if (value.length() > 0) {
            xhtml.element("dt", key);
            xhtml.element("dd", value);
        }
    }

    private String getChunk(StringChunk chunk) {
        try {
            return this.parser.getDocumentNode((Chunk)chunk).toString();
        }
        catch (ChunkNotFoundException e) {
            return "";
        }
    }
}

