/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.TextContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        if (metadata.get("Content-Type") == null) {
            metadata.set("Content-Type", "application/xml");
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.startElement("p");
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser parser = factory.newSAXParser();
            parser.parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler(this.getContentHandler(handler, metadata)));
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser configuration error", (Throwable)e);
        }
        xhtml.endElement("p");
        xhtml.endDocument();
    }

    protected ContentHandler getContentHandler(ContentHandler handler, Metadata metadata) {
        return new TextContentHandler(handler);
    }
}

