/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.html.HtmlHandler;
import org.apache.tika.parser.html.XHTMLDowngradeHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        stream = new CloseShieldInputStream(stream);
        InputSource source = new InputSource(stream);
        String encoding = metadata.get("Content-Encoding");
        if (encoding != null && Charset.isSupported(encoding)) {
            source.setEncoding(encoding);
        }
        org.ccil.cowan.tagsoup.Parser parser = new org.ccil.cowan.tagsoup.Parser();
        parser.setContentHandler((ContentHandler)((Object)new XHTMLDowngradeHandler((ContentHandler)((Object)new HtmlHandler(this, handler, metadata)))));
        parser.parse(source);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    protected String mapSafeElement(String name) {
        if ("H1".equals(name)) {
            return "h1";
        }
        if ("H2".equals(name)) {
            return "h2";
        }
        if ("H3".equals(name)) {
            return "h3";
        }
        if ("H4".equals(name)) {
            return "h4";
        }
        if ("H5".equals(name)) {
            return "h5";
        }
        if ("H6".equals(name)) {
            return "h6";
        }
        if ("P".equals(name)) {
            return "p";
        }
        if ("PRE".equals(name)) {
            return "pre";
        }
        if ("BLOCKQUOTE".equals(name)) {
            return "blockquote";
        }
        if ("UL".equals(name)) {
            return "ul";
        }
        if ("OL".equals(name)) {
            return "ol";
        }
        if ("MENU".equals(name)) {
            return "ul";
        }
        if ("LI".equals(name)) {
            return "li";
        }
        if ("DL".equals(name)) {
            return "dl";
        }
        if ("DT".equals(name)) {
            return "dt";
        }
        if ("DD".equals(name)) {
            return "dd";
        }
        if ("TABLE".equals(name)) {
            return "table";
        }
        if ("THEAD".equals(name)) {
            return "thead";
        }
        if ("TBODY".equals(name)) {
            return "tbody";
        }
        if ("TR".equals(name)) {
            return "tr";
        }
        if ("TH".equals(name)) {
            return "th";
        }
        if ("TD".equals(name)) {
            return "td";
        }
        return null;
    }

    protected boolean isDiscardElement(String name) {
        return "STYLE".equals(name) || "SCRIPT".equals(name);
    }
}

