/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.jpeg;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JpegParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, org.apache.tika.metadata.Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    public void parse(InputStream stream, ContentHandler handler, org.apache.tika.metadata.Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        try {
            Metadata jpegMetadata = JpegMetadataReader.readMetadata((InputStream)stream);
            Iterator directories = jpegMetadata.getDirectoryIterator();
            while (directories.hasNext()) {
                Directory directory = (Directory)directories.next();
                Iterator tags = directory.getTagIterator();
                while (tags.hasNext()) {
                    Tag tag = (Tag)tags.next();
                    metadata.set(tag.getTagName(), tag.getDescription());
                }
            }
        }
        catch (JpegProcessingException e) {
            throw new TikaException("Can't read JPEG metadata", (Throwable)e);
        }
        catch (MetadataException e) {
            throw new TikaException("Can't read JPEG metadata", (Throwable)e);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }
}

