/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.util.Locale;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.tika.parser.microsoft.ooxml.OOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.POIXMLTextExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSLFPowerPointExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSSFExcelExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XWPFWordExtractorDecorator;

public class OOXMLExtractorFactory {
    public static OOXMLExtractor createExtractor(POIXMLTextExtractor extractor, Locale locale) {
        POIXMLDocument document = extractor.getDocument();
        if (document instanceof XSLFSlideShow) {
            return new XSLFPowerPointExtractorDecorator((XSLFPowerPointExtractor)extractor);
        }
        if (document instanceof XSSFWorkbook) {
            return new XSSFExcelExtractorDecorator((XSSFExcelExtractor)extractor, locale);
        }
        if (document instanceof XWPFDocument) {
            return new XWPFWordExtractorDecorator((XWPFWordExtractor)extractor);
        }
        return new POIXMLTextExtractorDecorator(extractor);
    }
}

