/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TaggedInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POIFSContainerDetector
implements Detector {
    public static final MediaType OLE = MediaType.application((String)"x-tika-msoffice");
    public static final MediaType XLS = MediaType.application((String)"vnd.ms-excel");
    public static final MediaType DOC = MediaType.application((String)"msword");
    public static final MediaType PPT = MediaType.application((String)"vnd.ms-powerpoint");
    public static final MediaType PUB = MediaType.application((String)"x-mspublisher");
    public static final MediaType VSD = MediaType.application((String)"vnd.visio");
    public static final MediaType WPS = MediaType.application((String)"vnd.ms-works");
    public static final MediaType MSG = MediaType.application((String)"vnd.ms-outlook");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(8);
        try {
            if (input.read() != 208 || input.read() != 207 || input.read() != 17 || input.read() != 224 || input.read() != 161 || input.read() != 177 || input.read() != 26 || input.read() != 225) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
        }
        finally {
            input.reset();
        }
        if (!TikaInputStream.isTikaInputStream((InputStream)input)) {
            return OLE;
        }
        Set<String> names = POIFSContainerDetector.getTopLevelNames(TikaInputStream.get((InputStream)input));
        if (names.contains("Workbook")) {
            return XLS;
        }
        if (names.contains("EncryptedPackage")) {
            return OLE;
        }
        if (names.contains("WordDocument")) {
            return DOC;
        }
        if (names.contains("Quill")) {
            return PUB;
        }
        if (names.contains("PowerPoint Document")) {
            return PPT;
        }
        if (names.contains("VisioDocument")) {
            return VSD;
        }
        if (names.contains("CONTENTS")) {
            return WPS;
        }
        if (names.contains("\u0001Ole10Native")) {
            return OLE;
        }
        if (names.contains("PerfectOffice_MAIN")) {
            if (names.contains("SlideShow")) {
                return MediaType.application((String)"x-corelpresentations");
            }
            if (names.contains("PerfectOffice_OBJECTS")) {
                return MediaType.application((String)"x-quattro-pro");
            }
            return OLE;
        }
        if (names.contains("NativeContent_MAIN")) {
            return MediaType.application((String)"x-quattro-pro");
        }
        for (String name : names) {
            if (!name.startsWith("__substg1.0_")) continue;
            return MSG;
        }
        return OLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getTopLevelNames(TikaInputStream stream) throws IOException {
        File file = stream.getFile();
        TaggedInputStream tagged = new TaggedInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)));
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new CloseShieldInputStream((InputStream)tagged));
            stream.setOpenContainer((Object)fs);
            HashSet<String> names = new HashSet<String>();
            for (Entry entry : fs.getRoot()) {
                names.add(entry.getName());
            }
            HashSet<String> hashSet = names;
            return hashSet;
        }
        catch (IOException e) {
            tagged.throwIfCauseOf((Exception)e);
            Set<String> set = Collections.emptySet();
            return set;
        }
        catch (RuntimeException e) {
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            tagged.close();
        }
    }
}

