/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mail;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.mail.MailContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RFC822Parser
implements Parser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.parse((String)"message/rfc822"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        MimeStreamParser parser = new MimeStreamParser();
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        MailContentHandler mch = new MailContentHandler(xhtml, metadata);
        parser.setContentHandler((org.apache.james.mime4j.parser.ContentHandler)mch);
        parser.setContentDecoding(true);
        try {
            parser.parse(stream);
        }
        catch (MimeException e) {
            throw new TikaException(e.getMessage());
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

