/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class PagesContentHandler
extends DefaultHandler {
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;
    private boolean inMetaDataPart = false;
    private boolean parseProperty = false;
    private boolean inParsableText = false;
    private int pageCount = 0;
    private Map<String, List<List<String>>> tableData = new HashMap<String, List<List<String>>>();
    private String activeTableId;
    private int numberOfColumns = 0;
    private List<String> activeRow = new ArrayList<String>();
    private String metaDataLocalName;
    private String metaDataQName;

    PagesContentHandler(XHTMLContentHandler xhtml, Metadata metadata) {
        this.xhtml = xhtml;
        this.metadata = metadata;
    }

    public void endDocument() throws SAXException {
        this.metadata.set(Metadata.PAGE_COUNT, String.valueOf(this.pageCount));
        if (this.pageCount > 0) {
            this.xhtml.endElement("div");
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String value;
        if (this.parseProperty && (value = this.parsePrimitiveElementValue(qName, attributes)) != null) {
            Object metaDataKey = this.resolveMetaDataKey(this.metaDataLocalName);
            if (metaDataKey instanceof Property) {
                this.metadata.set((Property)metaDataKey, value);
            } else {
                this.metadata.add((String)metaDataKey, value);
            }
        }
        if ("sl:publication-info".equals(qName)) {
            this.inMetaDataPart = true;
        } else if ("sf:metadata".equals(qName)) {
            this.inMetaDataPart = true;
        } else if ("sf:page-start".equals(qName)) {
            if (this.pageCount > 0) {
                this.xhtml.endElement("div");
            }
            this.xhtml.startElement("div");
            ++this.pageCount;
        } else if ("sf:p".equals(qName) && this.pageCount > 0) {
            this.inParsableText = true;
            this.xhtml.startElement("p");
        } else if ("sf:attachment".equals(qName)) {
            String kind = attributes.getValue("sf:kind");
            if ("tabular-attachment".equals(kind)) {
                this.activeTableId = attributes.getValue("sfa:ID");
                this.tableData.put(this.activeTableId, new ArrayList());
            }
        } else if ("sf:attachment-ref".equals(qName)) {
            String idRef = attributes.getValue("sfa:IDREF");
            this.outputTable(idRef);
        }
        if (this.activeTableId != null) {
            this.parseTableData(qName, attributes);
        }
        if (this.inMetaDataPart) {
            this.metaDataLocalName = localName;
            this.metaDataQName = qName;
            this.parseProperty = true;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.metaDataLocalName != null && this.metaDataLocalName.equals(localName)) {
            this.metaDataLocalName = null;
            this.parseProperty = false;
        }
        if ("sl:publication-info".equals(qName)) {
            this.inMetaDataPart = false;
        } else if ("sf:metadata".equals(qName)) {
            this.inMetaDataPart = false;
        } else if ("sf:p".equals(qName) && this.pageCount > 0) {
            this.inParsableText = false;
            this.xhtml.endElement("p");
        } else if ("sf:attachment".equals(qName)) {
            this.activeTableId = null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inParsableText && length > 0) {
            this.xhtml.characters(ch, start, length);
        }
    }

    private void parseTableData(String qName, Attributes attributes) {
        if ("sf:grid".equals(qName)) {
            String numberOfColumns = attributes.getValue("sf:numcols");
            this.numberOfColumns = Integer.parseInt(numberOfColumns);
        } else if ("sf:ct".equals(qName)) {
            this.activeRow.add(attributes.getValue("sfa:s"));
            if (this.activeRow.size() >= 3) {
                this.tableData.get(this.activeTableId).add(this.activeRow);
                this.activeRow = new ArrayList<String>();
            }
        }
    }

    private void outputTable(String idRef) throws SAXException {
        List<List<String>> tableData = this.tableData.get(idRef);
        if (tableData != null) {
            this.xhtml.startElement("table");
            for (List<String> row : tableData) {
                this.xhtml.startElement("tr");
                for (String cell : row) {
                    this.xhtml.element("td", cell);
                }
                this.xhtml.endElement("tr");
            }
            this.xhtml.endElement("table");
        }
    }

    private Object resolveMetaDataKey(String metaDataLocalName) {
        String metaDataKey = metaDataLocalName;
        if ("sf:authors".equals(this.metaDataQName)) {
            metaDataKey = "Author";
        } else if ("sf:title".equals(this.metaDataQName)) {
            metaDataKey = "title";
        } else if ("sl:SLCreationDateProperty".equals(this.metaDataQName)) {
            metaDataKey = Metadata.CREATION_DATE;
        } else if ("sl:SLLastModifiedDateProperty".equals(this.metaDataQName)) {
            metaDataKey = Metadata.LAST_MODIFIED;
        } else if ("sl:language".equals(this.metaDataQName)) {
            metaDataKey = "language";
        }
        return metaDataKey;
    }

    private String parsePrimitiveElementValue(String qName, Attributes attributes) {
        if ("sl:string".equals(qName) || "sf:string".equals(qName)) {
            return attributes.getValue("sfa:string");
        }
        if ("sl:number".equals(qName)) {
            return attributes.getValue("sfa:number");
        }
        if ("sl:date".equals(qName)) {
            return attributes.getValue("sf:val");
        }
        return null;
    }
}

