/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pkg.PackageParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RarParser
extends AbstractParser {
    private static final long serialVersionUID = 6157727985054451501L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-rar-compressed"));

    public Set<MediaType> getSupportedTypes(ParseContext arg0) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        EmbeddedDocumentExtractor extractor = (EmbeddedDocumentExtractor)context.get(EmbeddedDocumentExtractor.class, (Object)new ParsingEmbeddedDocumentExtractor(context));
        TemporaryResources tmp = new TemporaryResources();
        Archive rar = null;
        try {
            TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
            rar = new Archive(tis.getFile());
            if (rar.isEncrypted()) {
                throw new EncryptedDocumentException();
            }
            xhtml.element("div", " ");
            FileHeader header = rar.nextFileHeader();
            while (header != null && !Thread.currentThread().isInterrupted()) {
                if (!header.isDirectory()) {
                    try (InputStream subFile = null;){
                        subFile = rar.getInputStream(header);
                        Metadata entrydata = PackageParser.handleEntryMetadata("".equals(header.getFileNameW()) ? header.getFileNameString() : header.getFileNameW(), header.getCTime(), header.getMTime(), header.getFullUnpackSize(), xhtml);
                        if (extractor.shouldParseEmbedded(entrydata)) {
                            extractor.parseEmbedded(subFile, handler, entrydata, true);
                        }
                    }
                }
                header = rar.nextFileHeader();
            }
        }
        catch (RarException e) {
            throw new TikaException("RarParser Exception", (Throwable)e);
        }
        finally {
            if (rar != null) {
                rar.close();
            }
            tmp.close();
        }
        xhtml.endDocument();
    }
}

