/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.netcdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NetCDFParser
extends AbstractParser {
    private static final long serialVersionUID = -5940938274907708665L;
    private final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-netcdf"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)new TemporaryResources());
        try {
            NetcdfFile ncFile = NetcdfFile.open((String)tis.getFile().getAbsolutePath());
            metadata.set("File-Type-Description", ncFile.getFileTypeDescription());
            for (Attribute attr : ncFile.getGlobalAttributes()) {
                Property property = this.resolveMetadataKey(attr.getFullName());
                if (attr.getDataType().isString()) {
                    metadata.add(property, attr.getStringValue());
                    continue;
                }
                if (!attr.getDataType().isNumeric()) continue;
                int value = attr.getNumericValue().intValue();
                metadata.add(property, String.valueOf(value));
            }
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            xhtml.newline();
            xhtml.element("h1", "dimensions");
            xhtml.startElement("ul");
            xhtml.newline();
            for (Dimension dim : ncFile.getDimensions()) {
                xhtml.element("li", dim.getFullName() + " = " + dim.getLength());
            }
            xhtml.endElement("ul");
            xhtml.element("h1", "variables");
            xhtml.startElement("ul");
            xhtml.newline();
            for (Variable var : ncFile.getVariables()) {
                xhtml.startElement("li");
                xhtml.characters(var.getDataType() + " " + var.getNameAndDimensions());
                xhtml.newline();
                List attributes = var.getAttributes();
                if (!attributes.isEmpty()) {
                    xhtml.startElement("ul");
                    for (Attribute element : attributes) {
                        xhtml.element("li", element.toString());
                    }
                    xhtml.endElement("ul");
                }
                xhtml.endElement("li");
            }
            xhtml.endElement("ul");
            xhtml.endDocument();
        }
        catch (IOException e) {
            throw new TikaException("NetCDF parse error", (Throwable)e);
        }
    }

    private Property resolveMetadataKey(String localName) {
        if ("title".equals(localName)) {
            return TikaCoreProperties.TITLE;
        }
        return Property.internalText((String)localName);
    }
}

