/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.parser.xml.AbstractMetadataHandler;
import org.xml.sax.Attributes;

public class ElementMetadataHandler
extends AbstractMetadataHandler {
    private static final Log logger = LogFactory.getLog(ElementMetadataHandler.class);
    private static final String LOCAL_NAME_RDF_BAG = "Bag";
    private static final String LOCAL_NAME_RDF_LI = "li";
    private static final String URI_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private final String uri;
    private final String localName;
    private final Metadata metadata;
    private final String name;
    private Property targetProperty;
    private final boolean allowDuplicateValues;
    private final boolean allowEmptyValues;
    private final StringBuilder bufferBagged = new StringBuilder();
    private final StringBuilder bufferBagless = new StringBuilder();
    private boolean isBagless = true;
    private int matchLevel = 0;
    private int parentMatchLevel = 0;

    public ElementMetadataHandler(String uri, String localName, Metadata metadata, String name) {
        super(metadata, name);
        this.uri = uri;
        this.localName = localName;
        this.metadata = metadata;
        this.name = name;
        this.allowDuplicateValues = false;
        this.allowEmptyValues = false;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created simple handler for " + this.name));
        }
    }

    public ElementMetadataHandler(String uri, String localName, Metadata metadata, String name, boolean allowDuplicateValues, boolean allowEmptyValues) {
        super(metadata, name);
        this.uri = uri;
        this.localName = localName;
        this.metadata = metadata;
        this.name = name;
        this.allowDuplicateValues = allowDuplicateValues;
        this.allowEmptyValues = allowEmptyValues;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created simple handler for " + this.name));
        }
    }

    public ElementMetadataHandler(String uri, String localName, Metadata metadata, Property targetProperty) {
        super(metadata, targetProperty);
        this.uri = uri;
        this.localName = localName;
        this.metadata = metadata;
        this.targetProperty = targetProperty;
        this.name = targetProperty.getName();
        this.allowDuplicateValues = false;
        this.allowEmptyValues = false;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created property handler for " + this.name));
        }
    }

    public ElementMetadataHandler(String uri, String localName, Metadata metadata, Property targetProperty, boolean allowDuplicateValues, boolean allowEmptyValues) {
        super(metadata, targetProperty);
        this.uri = uri;
        this.localName = localName;
        this.metadata = metadata;
        this.targetProperty = targetProperty;
        this.name = targetProperty.getName();
        this.allowDuplicateValues = allowDuplicateValues;
        this.allowEmptyValues = allowEmptyValues;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created property handler for " + this.name));
        }
    }

    protected boolean isMatchingParentElement(String uri, String localName) {
        return uri.equals(this.uri) && localName.equals(this.localName);
    }

    protected boolean isMatchingElement(String uri, String localName) {
        return uri.equals(this.uri) && localName.equals(this.localName) || this.parentMatchLevel > 0 && (uri.equals(URI_RDF) && localName.equals(LOCAL_NAME_RDF_BAG) || uri.equals(URI_RDF) && localName.equals(LOCAL_NAME_RDF_LI));
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        if (this.isMatchingElement(uri, localName)) {
            ++this.matchLevel;
        }
        if (this.isMatchingParentElement(uri, localName)) {
            ++this.parentMatchLevel;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        if (this.isMatchingParentElement(uri, localName)) {
            --this.parentMatchLevel;
        }
        if (this.isMatchingElement(uri, localName)) {
            --this.matchLevel;
            if (this.matchLevel == 2) {
                this.addMetadata(this.bufferBagged.toString().trim());
                this.bufferBagged.setLength(0);
                this.isBagless = false;
            }
            if (this.matchLevel == 0 && this.isBagless) {
                String valueBagless = this.bufferBagless.toString();
                if (valueBagless.length() > 0 && !valueBagless.contains(LOCAL_NAME_RDF_BAG)) {
                    this.addMetadata(valueBagless.trim());
                    this.bufferBagless.setLength(0);
                }
                this.isBagless = true;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.parentMatchLevel > 0 && this.matchLevel > 2) {
            this.bufferBagged.append(ch, start, length);
        }
        if (this.parentMatchLevel > 0 && this.matchLevel > 0) {
            this.bufferBagless.append(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.characters(ch, start, length);
    }

    @Override
    protected void addMetadata(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("adding " + this.name + "=" + value));
        }
        if (this.targetProperty != null && this.targetProperty.isMultiValuePermitted()) {
            if (value != null && value.length() > 0 || this.allowEmptyValues) {
                String[] previous;
                if (value == null || value.length() == 0 && this.allowEmptyValues) {
                    value = "";
                }
                if ((previous = this.metadata.getValues(this.name)) == null || !Arrays.asList(previous).contains(value) || this.allowDuplicateValues) {
                    this.metadata.add(this.targetProperty, value);
                }
            }
        } else {
            super.addMetadata(value);
        }
    }
}

