/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.HeaderFooter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.apache.poi.xssf.usermodel.helpers.HeaderFooterHelper;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.TikaExcelDataFormatter;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShape;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShapeNonVisual;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSSFExcelExtractorDecorator
extends AbstractOOXMLExtractor {
    protected static HeaderFooterHelper hfHelper = new HeaderFooterHelper();
    protected final DataFormatter formatter;
    protected final List<PackagePart> sheetParts = new ArrayList<PackagePart>();
    protected final Map<String, String> drawingHyperlinks = new HashMap<String, String>();
    protected Metadata metadata;
    protected ParseContext parseContext;

    public XSSFExcelExtractorDecorator(ParseContext context, POIXMLTextExtractor extractor, Locale locale) {
        super(context, extractor);
        this.parseContext = context;
        this.extractor = (XSSFEventBasedExcelExtractor)extractor;
        this.configureExtractor(this.extractor, locale);
        this.formatter = locale == null ? new TikaExcelDataFormatter() : new TikaExcelDataFormatter(locale);
    }

    protected void configureExtractor(POIXMLTextExtractor extractor, Locale locale) {
        ((XSSFEventBasedExcelExtractor)extractor).setIncludeTextBoxes(this.config.getIncludeShapeBasedContent());
        ((XSSFEventBasedExcelExtractor)extractor).setFormulasNotResults(false);
        ((XSSFEventBasedExcelExtractor)extractor).setLocale(locale);
    }

    @Override
    public void getXHTML(ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        this.metadata = metadata;
        this.parseContext = context;
        metadata.set("protected", "false");
        super.getXHTML(handler, metadata, context);
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        ReadOnlySharedStringsTable strings;
        XSSFReader.SheetIterator iter;
        StylesTable styles;
        OPCPackage container = this.extractor.getPackage();
        try {
            XSSFReader xssfReader = new XSSFReader(container);
            styles = xssfReader.getStylesTable();
            iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            strings = new ReadOnlySharedStringsTable(container);
        }
        catch (InvalidFormatException e) {
            throw new XmlException((Throwable)e);
        }
        catch (OpenXML4JException oe) {
            throw new XmlException((Throwable)oe);
        }
        HashSet<String> seen = new HashSet<String>();
        while (iter.hasNext()) {
            SheetTextAsHTML sheetExtractor = new SheetTextAsHTML(xhtml);
            PackagePart sheetPart = null;
            Iterator<String> stream = iter.next();
            Throwable throwable = null;
            try {
                sheetPart = iter.getSheetPart();
                String partName = sheetPart.getPartName().toString();
                if (seen.contains(partName)) continue;
                seen.add(partName);
                this.addDrawingHyperLinks(sheetPart);
                this.sheetParts.add(sheetPart);
                CommentsTable comments = iter.getSheetComments();
                xhtml.startElement("div");
                xhtml.element("h1", iter.getSheetName());
                xhtml.startElement("table");
                xhtml.startElement("tbody");
                this.processSheet(sheetExtractor, comments, styles, strings, (InputStream)((Object)stream));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)((Object)stream)).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)((Object)stream)).close();
                continue;
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
            for (String header : sheetExtractor.headers) {
                this.extractHeaderFooter(header, xhtml);
            }
            for (String footer : sheetExtractor.footers) {
                this.extractHeaderFooter(footer, xhtml);
            }
            if (this.config.getIncludeShapeBasedContent()) {
                List shapes = iter.getShapes();
                this.processShapes(shapes, xhtml);
            }
            this.extractHyperLinks(sheetPart, xhtml);
            xhtml.endElement("div");
        }
    }

    protected void addDrawingHyperLinks(PackagePart sheetPart) {
        try {
            for (PackageRelationship rel : sheetPart.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation())) {
                if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                PackagePartName relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
                PackagePart part = rel.getPackage().getPart(relName);
                if (part == null) continue;
                for (PackageRelationship drawRel : part.getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation())) {
                    this.drawingHyperlinks.put(drawRel.getId(), drawRel.getTargetURI().toString());
                }
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    private void extractHyperLinks(PackagePart sheetPart, XHTMLContentHandler xhtml) throws SAXException {
        try {
            for (PackageRelationship rel : sheetPart.getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation())) {
                xhtml.startElement("a", "href", rel.getTargetURI().toString());
                xhtml.characters(rel.getTargetURI().toString());
                xhtml.endElement("a");
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    protected void extractHeaderFooter(String hf, XHTMLContentHandler xhtml) throws SAXException {
        String content = ExcelExtractor._extractHeaderFooter((HeaderFooter)new HeaderFooterFromString(hf));
        if (content.length() > 0) {
            xhtml.element("p", content);
        }
    }

    private void processShapes(List<XSSFShape> shapes, XHTMLContentHandler xhtml) throws SAXException {
        if (shapes == null) {
            return;
        }
        for (XSSFShape shape : shapes) {
            if (!(shape instanceof XSSFSimpleShape)) continue;
            String sText = ((XSSFSimpleShape)shape).getText();
            if (sText != null && sText.length() > 0) {
                xhtml.element("p", sText);
            }
            this.extractHyperLinksFromShape(((XSSFSimpleShape)shape).getCTShape(), xhtml);
        }
    }

    private void extractHyperLinksFromShape(CTShape ctShape, XHTMLContentHandler xhtml) throws SAXException {
        CTHyperlink ctHoverHyperlink;
        if (ctShape == null) {
            return;
        }
        CTShapeNonVisual nvSpPR = ctShape.getNvSpPr();
        if (nvSpPR == null) {
            return;
        }
        CTNonVisualDrawingProps cNvPr = nvSpPR.getCNvPr();
        if (cNvPr == null) {
            return;
        }
        CTHyperlink ctHyperlink = cNvPr.getHlinkClick();
        if (ctHyperlink == null) {
            return;
        }
        String url = this.drawingHyperlinks.get(ctHyperlink.getId());
        if (url != null) {
            xhtml.startElement("a", "href", url);
            xhtml.characters(url);
            xhtml.endElement("a");
        }
        if ((ctHoverHyperlink = cNvPr.getHlinkHover()) == null) {
            return;
        }
        url = this.drawingHyperlinks.get(ctHoverHyperlink.getId());
        if (url != null) {
            xhtml.startElement("a", "href", url);
            xhtml.characters(url);
            xhtml.endElement("a");
        }
    }

    public void processSheet(XSSFSheetXMLHandler.SheetContentsHandler sheetContentsExtractor, CommentsTable comments, StylesTable styles, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, SAXException {
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = this.parseContext.getXMLReader();
            XSSFSheetInterestingPartsCapturer handler = new XSSFSheetInterestingPartsCapturer((ContentHandler)new XSSFSheetXMLHandler(styles, comments, strings, sheetContentsExtractor, this.formatter, false));
            sheetParser.setContentHandler(handler);
            sheetParser.parse(sheetSource);
            sheetInputStream.close();
            if (handler.hasProtection) {
                this.metadata.set("protected", "true");
            }
        }
        catch (TikaException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        for (PackagePart part : this.sheetParts) {
            parts.add(part);
            try {
                PackagePartName relName;
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.VML_DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException e) {
                throw new TikaException("Broken OOXML file", (Throwable)e);
            }
        }
        for (PackagePart part : this.extractor.getPackage().getPartsByRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument")) {
            parts.add(part);
        }
        return parts;
    }

    protected static class XSSFSheetInterestingPartsCapturer
    implements ContentHandler {
        private ContentHandler delegate;
        private boolean hasProtection = false;

        protected XSSFSheetInterestingPartsCapturer(ContentHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("sheetProtection".equals(qName)) {
                this.hasProtection = true;
            }
            this.delegate.startElement(uri, localName, qName, atts);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.delegate.characters(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            this.delegate.endDocument();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.delegate.endElement(uri, localName, qName);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.delegate.endPrefixMapping(prefix);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.delegate.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.delegate.processingInstruction(target, data);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.delegate.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.delegate.skippedEntity(name);
        }

        @Override
        public void startDocument() throws SAXException {
            this.delegate.startDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.delegate.startPrefixMapping(prefix, uri);
        }
    }

    protected static class HeaderFooterFromString
    implements HeaderFooter {
        private String text;

        protected HeaderFooterFromString(String text) {
            this.text = text;
        }

        public String getCenter() {
            return hfHelper.getCenterSection(this.text);
        }

        public void setCenter(String paramString) {
        }

        public String getLeft() {
            return hfHelper.getLeftSection(this.text);
        }

        public void setLeft(String paramString) {
        }

        public String getRight() {
            return hfHelper.getRightSection(this.text);
        }

        public void setRight(String paramString) {
        }
    }

    protected static class SheetTextAsHTML
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private XHTMLContentHandler xhtml;
        protected List<String> headers;
        protected List<String> footers;

        protected SheetTextAsHTML(XHTMLContentHandler xhtml) {
            this.xhtml = xhtml;
            this.headers = new ArrayList<String>();
            this.footers = new ArrayList<String>();
        }

        public void startRow(int rowNum) {
            try {
                this.xhtml.startElement("tr");
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        public void endRow(int rowNum) {
            try {
                this.xhtml.endElement("tr");
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        public void cell(String cellRef, String formattedValue, XSSFComment comment) {
            try {
                this.xhtml.startElement("td");
                if (formattedValue != null) {
                    this.xhtml.characters(formattedValue);
                }
                if (comment != null) {
                    this.xhtml.startElement("br");
                    this.xhtml.endElement("br");
                    this.xhtml.characters(comment.getAuthor());
                    this.xhtml.characters(": ");
                    this.xhtml.characters(comment.getString().getString());
                }
                this.xhtml.endElement("td");
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
            if (isHeader) {
                this.headers.add(text);
            } else {
                this.footers.add(text);
            }
        }
    }
}

