/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pkg.CompressorParserOptions;
import org.apache.tika.parser.pkg.TikaCompressorStreamFactory;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CompressorParser
extends AbstractParser {
    private static final long serialVersionUID = 2793565792967222459L;
    private static final MediaType BZIP = MediaType.application((String)"x-bzip");
    private static final MediaType BZIP2 = MediaType.application((String)"x-bzip2");
    private static final MediaType GZIP = MediaType.application((String)"gzip");
    private static final MediaType GZIP_ALT = MediaType.application((String)"x-gzip");
    private static final MediaType COMPRESS = MediaType.application((String)"x-compress");
    private static final MediaType XZ = MediaType.application((String)"x-xz");
    private static final MediaType PACK = MediaType.application((String)"x-java-pack200");
    private static final MediaType SNAPPY = MediaType.application((String)"x-snappy-framed");
    private static final MediaType ZLIB = MediaType.application((String)"zlib");
    private static final MediaType LZMA = MediaType.application((String)"x-lzma");
    private static final Set<MediaType> SUPPORTED_TYPES = MediaType.set((MediaType[])new MediaType[]{BZIP, BZIP2, GZIP, GZIP_ALT, COMPRESS, XZ, PACK, ZLIB, LZMA});
    private int memoryLimitInKb = 100000;

    static MediaType getMediaType(CompressorInputStream stream) {
        if (stream instanceof BZip2CompressorInputStream) {
            return BZIP2;
        }
        if (stream instanceof GzipCompressorInputStream) {
            return GZIP;
        }
        if (stream instanceof XZCompressorInputStream) {
            return XZ;
        }
        if (stream instanceof DeflateCompressorInputStream) {
            return ZLIB;
        }
        if (stream instanceof ZCompressorInputStream) {
            return COMPRESS;
        }
        if (stream instanceof Pack200CompressorInputStream) {
            return PACK;
        }
        if (stream instanceof FramedSnappyCompressorInputStream || stream instanceof SnappyCompressorInputStream) {
            return SNAPPY;
        }
        if (stream instanceof LZMACompressorInputStream) {
            return LZMA;
        }
        return MediaType.OCTET_STREAM;
    }

    static MediaType getMediaType(String name) {
        if ("bzip2".equals(name)) {
            return BZIP2;
        }
        if ("gz".equals(name)) {
            return GZIP;
        }
        if ("xz".equals(name)) {
            return XZ;
        }
        if ("deflate".equals(name)) {
            return ZLIB;
        }
        if ("z".equals(name)) {
            return COMPRESS;
        }
        if ("pack200".equals(name)) {
            return PACK;
        }
        if ("snappy-framed".equals(name) || "snappy-raw".equals(name)) {
            return SNAPPY;
        }
        if ("lzma".equals(name)) {
            return LZMA;
        }
        return MediaType.OCTET_STREAM;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        CompressorInputStream cis;
        stream = stream.markSupported() ? new CloseShieldInputStream(stream) : new BufferedInputStream((InputStream)new CloseShieldInputStream(stream));
        try {
            CompressorParserOptions options = (CompressorParserOptions)context.get(CompressorParserOptions.class, (Object)new CompressorParserOptions(){

                @Override
                public boolean decompressConcatenated(Metadata metadata) {
                    return false;
                }
            });
            TikaCompressorStreamFactory factory = new TikaCompressorStreamFactory(options.decompressConcatenated(metadata), this.memoryLimitInKb);
            cis = factory.createCompressorInputStream(stream);
        }
        catch (CompressorException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("MemoryLimitException:")) {
                throw new TikaMemoryLimitException(e.getMessage());
            }
            throw new TikaException("Unable to uncompress document stream", (Throwable)e);
        }
        MediaType type = CompressorParser.getMediaType(cis);
        if (!type.equals((Object)MediaType.OCTET_STREAM)) {
            metadata.set("Content-Type", type.toString());
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            EmbeddedDocumentExtractor extractor;
            Metadata entrydata = new Metadata();
            String name = metadata.get("resourceName");
            if (name != null) {
                if (name.endsWith(".tbz")) {
                    name = name.substring(0, name.length() - 4) + ".tar";
                } else if (name.endsWith(".tbz2")) {
                    name = name.substring(0, name.length() - 5) + ".tar";
                } else if (name.endsWith(".bz")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.endsWith(".bz2")) {
                    name = name.substring(0, name.length() - 4);
                } else if (name.endsWith(".xz")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.endsWith(".zlib")) {
                    name = name.substring(0, name.length() - 5);
                } else if (name.endsWith(".pack")) {
                    name = name.substring(0, name.length() - 5);
                } else if (name.length() > 0) {
                    name = GzipUtils.getUncompressedFilename((String)name);
                }
                entrydata.set("resourceName", name);
            }
            if ((extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context)).shouldParseEmbedded(entrydata)) {
                extractor.parseEmbedded((InputStream)cis, (ContentHandler)xhtml, entrydata, true);
            }
        }
        finally {
            cis.close();
        }
        xhtml.endDocument();
    }

    @Field
    public void setMemoryLimitInKb(int memoryLimitInKb) {
        this.memoryLimitInKb = memoryLimitInKb;
    }
}

