/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.envi;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.AutoDetectReader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractEncodingDetectorParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EnviHeaderParser
extends AbstractEncodingDetectorParser {
    private static final long serialVersionUID = -1479368523072408091L;
    public static final String ENVI_MIME_TYPE = "application/envi.hdr";
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"envi.hdr"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", ENVI_MIME_TYPE);
        TikaConfig tikaConfig = (TikaConfig)context.get(TikaConfig.class);
        if (tikaConfig == null) {
            tikaConfig = TikaConfig.getDefaultConfig();
        }
        try (AutoDetectReader reader = new AutoDetectReader((InputStream)new CloseShieldInputStream(stream), metadata, this.getEncodingDetector(context));){
            String line;
            Charset charset = reader.getCharset();
            MediaType type = new MediaType(MediaType.TEXT_PLAIN, charset);
            metadata.set("Content-Encoding", charset.name());
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            while ((line = reader.readLine()) != null) {
                xhtml.startElement("p");
                xhtml.characters(line);
                xhtml.endElement("p");
            }
            xhtml.endDocument();
        }
    }
}

