/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image.xmp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.image.xmp.XMPPacketScanner;
import org.xml.sax.InputSource;

public class JempboxExtractor {
    private XMPPacketScanner scanner = new XMPPacketScanner();
    private Metadata metadata;
    private static final String DEFAULT_XMP_CHARSET = "UTF-8";

    public JempboxExtractor(Metadata metadata) {
        this.metadata = metadata;
    }

    public void parse(InputStream file) throws IOException, TikaException {
        ByteArrayOutputStream xmpraw = new ByteArrayOutputStream();
        if (!this.scanner.parse(file, xmpraw)) {
            return;
        }
        InputStreamReader decoded = new InputStreamReader((InputStream)new ByteArrayInputStream(xmpraw.toByteArray()), DEFAULT_XMP_CHARSET);
        try {
            XMPMetadata xmp = XMPMetadata.load((InputSource)new InputSource(decoded));
            XMPSchemaDublinCore dc = xmp.getDublinCoreSchema();
            if (dc != null) {
                if (dc.getTitle() != null) {
                    this.metadata.set(TikaCoreProperties.TITLE, dc.getTitle());
                }
                if (dc.getDescription() != null) {
                    this.metadata.set(TikaCoreProperties.DESCRIPTION, dc.getDescription());
                }
                if (dc.getCreators() != null && dc.getCreators().size() > 0) {
                    this.metadata.set(TikaCoreProperties.CREATOR, this.joinCreators(dc.getCreators()));
                }
                if (dc.getSubjects() != null && dc.getSubjects().size() > 0) {
                    Iterator keywords = dc.getSubjects().iterator();
                    while (keywords.hasNext()) {
                        this.metadata.add(TikaCoreProperties.KEYWORDS, (String)keywords.next());
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected String joinCreators(List<String> creators) {
        if (creators == null || creators.size() == 0) {
            return "";
        }
        if (creators.size() == 1) {
            return creators.get(0);
        }
        StringBuffer c = new StringBuffer();
        for (String s : creators) {
            c.append(", ").append(s);
        }
        return c.substring(2);
    }
}

