/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.isatab;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.isatab.ISATabUtils;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ISArchiveParser
implements Parser {
    private static final long serialVersionUID = 3640809327541300229L;
    private final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-isatab"));
    private static String studyAssayFileNameField = "Study Assay File Name";
    private String location = null;
    private String studyFileName = null;

    public ISArchiveParser() {
        this(null);
    }

    public ISArchiveParser(String location) {
        if (location != null && !location.endsWith(File.separator)) {
            location = location + File.separator;
        }
        this.location = location;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TikaInputStream tis = TikaInputStream.get((InputStream)stream);
        if (this.location == null) {
            this.location = tis.getFile().getParent() + File.separator;
        }
        this.studyFileName = tis.getFile().getName();
        File locationFile = new File(this.location);
        String[] investigationList = locationFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("i_.+\\.txt");
            }
        });
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.parseInvestigation(investigationList, xhtml, metadata, context);
        this.parseStudy(stream, xhtml, metadata, context);
        this.parseAssay(xhtml, metadata, context);
        xhtml.endDocument();
    }

    private void parseInvestigation(String[] investigationList, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (investigationList == null || investigationList.length == 0) {
            return;
        }
        if (investigationList.length > 1) {
            return;
        }
        String investigation = investigationList[0];
        TikaInputStream stream = TikaInputStream.get((File)new File(this.location + investigation));
        ISATabUtils.parseInvestigation((InputStream)stream, xhtml, metadata, context, this.studyFileName);
        xhtml.element("h1", "INVESTIGATION " + metadata.get("Investigation Identifier"));
    }

    private void parseStudy(InputStream stream, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        xhtml.element("h2", "STUDY " + metadata.get("Study Identifier"));
        ISATabUtils.parseStudy(stream, xhtml, metadata, context);
    }

    private void parseAssay(XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        for (String assayFileName : metadata.getValues(studyAssayFileNameField)) {
            xhtml.startElement("div");
            xhtml.element("h3", "ASSAY " + assayFileName);
            TikaInputStream stream = TikaInputStream.get((File)new File(this.location + assayFileName));
            ISATabUtils.parseAssay((InputStream)stream, xhtml, metadata, context);
            xhtml.endElement("div");
        }
    }
}

