/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.jdbc.AbstractDBParser;
import org.apache.tika.parser.jdbc.JDBCTableReader;
import org.apache.tika.parser.jdbc.SQLite3TableReader;
import org.sqlite.SQLiteConfig;

class SQLite3DBParser
extends AbstractDBParser {
    protected static final String SQLITE_CLASS_NAME = "org.sqlite.JDBC";

    SQLite3DBParser() {
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return null;
    }

    @Override
    protected Connection getConnection(InputStream stream, Metadata metadata, ParseContext context) throws IOException {
        String connectionString = this.getConnectionString(stream, metadata, context);
        Connection connection = null;
        try {
            Class.forName(this.getJDBCClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
        try {
            SQLiteConfig config = new SQLiteConfig();
            config.setReadOnly(true);
            connection = config.createConnection(connectionString);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        return connection;
    }

    @Override
    protected String getConnectionString(InputStream is, Metadata metadata, ParseContext context) throws IOException {
        File dbFile = TikaInputStream.get((InputStream)is).getFile();
        return "jdbc:sqlite:" + dbFile.getAbsolutePath();
    }

    @Override
    protected String getJDBCClassName() {
        return SQLITE_CLASS_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> getTableNames(Connection connection, Metadata metadata, ParseContext context) throws SQLException {
        LinkedList<String> tableNames = new LinkedList<String>();
        Statement st = null;
        try {
            st = connection.createStatement();
            String sql = "SELECT name FROM sqlite_master WHERE type='table'";
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                tableNames.add(rs.getString(1));
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        return tableNames;
    }

    @Override
    public JDBCTableReader getTableReader(Connection connection, String tableName, ParseContext context) {
        return new SQLite3TableReader(connection, tableName, context);
    }
}

