/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.RTFMetadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.rtf.RTFObjDataParser;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.parser.rtf.TextExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class RTFEmbObjHandler {
    private static final String EMPTY_STRING = "";
    private final ContentHandler handler;
    private final ParseContext context;
    private final ByteArrayOutputStream os;
    private int hi = -1;
    private int thumbCount = 0;
    private AtomicInteger unknownFilenameCount = new AtomicInteger();
    private boolean inObject = false;
    private String sv = "";
    private String sn = "";
    private StringBuilder sb = new StringBuilder();
    private Metadata metadata;
    private EMB_STATE state = EMB_STATE.NADA;

    protected RTFEmbObjHandler(ContentHandler handler, Metadata metadata, ParseContext context) {
        this.handler = handler;
        this.context = context;
        this.os = new ByteArrayOutputStream();
    }

    protected void startPict() {
        this.state = EMB_STATE.PICT;
        this.metadata = new Metadata();
    }

    protected void startObjData() {
        this.state = EMB_STATE.OBJDATA;
        this.metadata = new Metadata();
    }

    protected void startSN() {
        this.sb.setLength(0);
        this.sb.append("rtf_pict:");
    }

    protected void endSN() {
        this.sn = this.sb.toString();
    }

    protected void startSV() {
        this.sb.setLength(0);
    }

    protected void endSV() {
        this.sv = this.sb.toString();
    }

    protected void endSP() {
        this.metadata.add(this.sn, this.sv);
    }

    protected boolean getInObject() {
        return this.inObject;
    }

    protected void setInObject(boolean v) {
        this.inObject = v;
    }

    protected void writeMetadataChar(char c) {
        this.sb.append(c);
    }

    protected void writeHexChar(int b) throws IOException, TikaException {
        if (TextExtractor.isHexChar(b)) {
            if (this.hi == -1) {
                this.hi = 16 * TextExtractor.hexValue(b);
            } else {
                long sum = this.hi + TextExtractor.hexValue(b);
                if (sum > Integer.MAX_VALUE || sum < 0L) {
                    throw new IOException("hex char to byte overflow");
                }
                this.os.write((int)sum);
                this.hi = -1;
            }
            return;
        }
        if (b == -1) {
            throw new TikaException("hit end of stream before finishing byte pair");
        }
    }

    protected void writeBytes(InputStream is, int len) throws IOException, TikaException {
        if (len < 0 || len > RTFParser.getMaxBytesForEmbeddedObject()) {
            throw new IOException("length of bytes to read out of bounds: " + len);
        }
        byte[] bytes = new byte[len];
        int bytesRead = is.read(bytes);
        if (bytesRead < len) {
            throw new TikaException("unexpected end of file: need " + len + " bytes of binary data, found " + (len - bytesRead));
        }
        this.os.write(bytes);
    }

    protected void handleCompletedObject() throws IOException, SAXException, TikaException {
        EmbeddedDocumentExtractor embeddedExtractor = (EmbeddedDocumentExtractor)this.context.get(EmbeddedDocumentExtractor.class);
        if (embeddedExtractor == null) {
            embeddedExtractor = new ParsingEmbeddedDocumentExtractor(this.context);
        }
        byte[] bytes = this.os.toByteArray();
        if (this.state == EMB_STATE.OBJDATA) {
            RTFObjDataParser objParser = new RTFObjDataParser();
            try {
                byte[] objBytes = objParser.parse(bytes, this.metadata, this.unknownFilenameCount);
                this.extractObj(objBytes, this.handler, embeddedExtractor, this.metadata);
            }
            catch (IOException e) {}
        } else if (this.state == EMB_STATE.PICT) {
            String filePath = this.metadata.get("rtf_pict:wzDescription");
            if (filePath != null && filePath.length() > 0) {
                this.metadata.set("embeddedRelationshipId", filePath);
                this.metadata.set("resourceName", FilenameUtils.getName((String)filePath));
            }
            this.metadata.set(RTFMetadata.THUMBNAIL, Boolean.toString(this.inObject));
            this.extractObj(bytes, this.handler, embeddedExtractor, this.metadata);
        } else if (this.state == EMB_STATE.NADA) {
            // empty if block
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractObj(byte[] bytes, ContentHandler handler, EmbeddedDocumentExtractor embeddedExtractor, Metadata metadata) throws SAXException, IOException, TikaException {
        if (bytes == null) {
            return;
        }
        metadata.set("Content-Length", Integer.toString(bytes.length));
        if (embeddedExtractor.shouldParseEmbedded(metadata)) {
            TikaInputStream stream = TikaInputStream.get((byte[])bytes);
            if (metadata.get("resourceName") == null) {
                String extension = this.getExtension(stream, metadata);
                stream.reset();
                if (this.inObject && this.state == EMB_STATE.PICT) {
                    metadata.set("resourceName", "thumbnail_" + this.thumbCount++ + extension);
                    metadata.set(RTFMetadata.THUMBNAIL, "true");
                } else {
                    metadata.set("resourceName", "file_" + this.unknownFilenameCount.getAndIncrement() + extension);
                }
            }
            try {
                embeddedExtractor.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler(handler), metadata, false);
            }
            finally {
                stream.close();
            }
        }
    }

    private String getExtension(TikaInputStream is, Metadata metadata) {
        String cType = metadata.get("Content-Type");
        TikaConfig config = this.getConfig();
        if (cType == null) {
            Detector detector = config.getDetector();
            try {
                MediaType mediaType = detector.detect((InputStream)is, metadata);
                MimeTypes types = config.getMimeRepository();
                MimeType mime = types.forName(mediaType.toString());
                metadata.set("Content-Type", mediaType.getSubtype());
                return mime.getExtension();
            }
            catch (IOException e) {
            }
            catch (MimeTypeException e) {
                // empty catch block
            }
        }
        return ".bin";
    }

    private TikaConfig getConfig() {
        TikaConfig config = (TikaConfig)this.context.get(TikaConfig.class);
        if (config == null) {
            config = TikaConfig.getDefaultConfig();
        }
        return config;
    }

    protected void reset() {
        this.state = EMB_STATE.NADA;
        this.os.reset();
        this.metadata = new Metadata();
        this.hi = -1;
        this.sv = EMPTY_STRING;
        this.sn = EMPTY_STRING;
        this.sb.setLength(0);
    }

    private static enum EMB_STATE {
        PICT,
        OBJDATA,
        NADA;

    }
}

