/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.reporters.fs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.PipesReporter;
import org.apache.tika.pipes.PipesResult;
import org.apache.tika.pipes.async.AsyncStatus;
import org.apache.tika.pipes.pipesiterator.TotalCountResult;
import org.apache.tika.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemStatusReporter
extends PipesReporter
implements Initializable {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemStatusReporter.class);
    ObjectMapper objectMapper;
    private Path statusFile;
    private long reportUpdateMillis = 1000L;
    private volatile boolean crashed = false;
    Thread reporterThread;
    private ConcurrentHashMap<PipesResult.STATUS, LongAdder> counts = new ConcurrentHashMap();
    private AsyncStatus asyncStatus = new AsyncStatus();
    private TotalCountResult totalCountResult = new TotalCountResult(0L, TotalCountResult.STATUS.NOT_COMPLETED);

    @Field
    public void setStatusFile(String path) {
        this.statusFile = Paths.get(path, new String[0]);
    }

    @Field
    public void setReportUpdateMillis(long millis) {
        this.reportUpdateMillis = millis;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule(new JavaTimeModule())).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).build();
        this.reporterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(FileSystemStatusReporter.this.reportUpdateMillis);
                        FileSystemStatusReporter.this.report(AsyncStatus.ASYNC_STATUS.STARTED);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        this.reporterThread.setDaemon(true);
        this.reporterThread.start();
    }

    private synchronized void report(AsyncStatus.ASYNC_STATUS status) {
        HashMap localCounts = new HashMap();
        this.counts.entrySet().forEach(e -> localCounts.put((PipesResult.STATUS)e.getKey(), ((LongAdder)e.getValue()).longValue()));
        this.asyncStatus.update(localCounts, this.totalCountResult, status);
        try (BufferedWriter writer = Files.newBufferedWriter(this.statusFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.objectMapper.writeValue(writer, (Object)this.asyncStatus);
        }
        catch (IOException e2) {
            LOG.warn("couldn't write report", (Throwable)e2);
        }
    }

    private synchronized void crash(String crashMessage) {
        this.asyncStatus.updateCrash(crashMessage);
        try (BufferedWriter writer = Files.newBufferedWriter(this.statusFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.objectMapper.writeValue(writer, (Object)this.asyncStatus);
        }
        catch (IOException e) {
            LOG.warn("couldn't write report", (Throwable)e);
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        if (this.statusFile == null) {
            throw new TikaConfigException("must initialize 'statusFile'");
        }
        if (!Files.isDirectory(this.statusFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(this.statusFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new TikaConfigException("couldn't create directory for status file", (Throwable)e);
            }
        }
    }

    public void close() throws IOException {
        LOG.debug("finishing and writing last report");
        this.interuptThread();
        if (!this.crashed) {
            this.report(AsyncStatus.ASYNC_STATUS.COMPLETED);
        }
    }

    private void interuptThread() {
        this.reporterThread.interrupt();
        try {
            this.reporterThread.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void error(Throwable t) {
        this.crashed = true;
        this.interuptThread();
        this.crash(ExceptionUtils.getStackTrace((Throwable)t));
    }

    public void error(String msg) {
        this.crashed = true;
        this.interuptThread();
        this.crash(msg);
    }

    public void report(FetchEmitTuple t, PipesResult result, long elapsed) {
        this.counts.computeIfAbsent(result.getStatus(), k -> new LongAdder()).increment();
    }

    public void report(TotalCountResult totalCountResult) {
        this._report(totalCountResult);
    }

    private synchronized void _report(TotalCountResult totalCountResult) {
        this.totalCountResult = totalCountResult;
    }

    public boolean supportsTotalCount() {
        return true;
    }
}

