/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.io.Writer;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadataDeserializer;
import org.apache.tika.metadata.serialization.JsonMetadataSerializer;

public class JsonMetadata {
    private static Gson GSON;

    public static void toJson(Metadata metadata, Writer writer) throws TikaException {
        try {
            GSON.toJson((Object)metadata, (Appendable)writer);
        }
        catch (JsonIOException e) {
            throw new TikaException(e.getMessage());
        }
    }

    public static Metadata fromJson(Reader reader) throws TikaException {
        Metadata m = null;
        try {
            m = (Metadata)GSON.fromJson(reader, Metadata.class);
        }
        catch (JsonParseException e) {
            throw new TikaException(e.getMessage());
        }
        return m;
    }

    public static void setGson(Gson gson) {
        GSON = gson;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeHierarchyAdapter(Metadata.class, (Object)new JsonMetadataSerializer());
        builder.registerTypeHierarchyAdapter(Metadata.class, (Object)new JsonMetadataDeserializer());
        GSON = builder.create();
    }
}

