/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.metadata.serialization.JsonFetchEmitTuple;
import org.apache.tika.pipes.FetchEmitTuple;

public class JsonFetchEmitTupleList {
    public static List<FetchEmitTuple> fromJson(Reader reader) throws IOException {
        ArrayList<FetchEmitTuple> list;
        try (JsonParser jParser = new JsonFactory().createParser(reader);){
            JsonToken token = jParser.nextToken();
            if (token != JsonToken.START_ARRAY) {
                throw new IOException("require start array, but see: " + token.name());
            }
            list = new ArrayList<FetchEmitTuple>();
            while (token != JsonToken.END_ARRAY) {
                list.add(JsonFetchEmitTuple.parseFetchEmitTuple(jParser));
                token = jParser.nextToken();
            }
        }
        return list;
    }

    public static String toJson(List<FetchEmitTuple> list) throws IOException {
        StringWriter writer = new StringWriter();
        JsonFetchEmitTupleList.toJson(list, writer);
        return writer.toString();
    }

    public static void toJson(List<FetchEmitTuple> list, Writer writer) throws IOException {
        try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
            jsonGenerator.writeStartArray();
            for (FetchEmitTuple t : list) {
                JsonFetchEmitTuple.writeTuple(t, jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        }
    }
}

