/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.ByteBufferInputStream;
import com.jmatio.io.HeapBufferDataOutputStream;
import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatFileInputStream;
import com.jmatio.io.MatTag;
import com.jmatio.io.MatlabIOException;
import com.jmatio.types.ByteStorageSupport;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLEmptyArray;
import com.jmatio.types.MLInt16;
import com.jmatio.types.MLInt32;
import com.jmatio.types.MLInt64;
import com.jmatio.types.MLInt8;
import com.jmatio.types.MLJavaObject;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLObject;
import com.jmatio.types.MLSingle;
import com.jmatio.types.MLSparse;
import com.jmatio.types.MLStructure;
import com.jmatio.types.MLUInt32;
import com.jmatio.types.MLUInt64;
import com.jmatio.types.MLUInt8;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import sun.misc.Cleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileReader {
    public static final int MEMORY_MAPPED_FILE = 1;
    public static final int DIRECT_BYTE_BUFFER = 2;
    public static final int HEAP_BYTE_BUFFER = 4;
    private MatFileHeader matFileHeader;
    private Map<String, MLArray> data;
    private ByteOrder byteOrder;
    private MatFileFilter filter = new MatFileFilter();
    private static final int DIRECT_BUFFER_LIMIT = 0x2000000;

    public MatFileReader(String fileName) throws FileNotFoundException, IOException {
        this(new File(fileName), new MatFileFilter());
    }

    public MatFileReader(String fileName, MatFileFilter filter) throws IOException {
        this(new File(fileName), filter);
    }

    public MatFileReader(File file) throws IOException {
        this(file, new MatFileFilter());
    }

    public MatFileReader(File file, MatFileFilter filter) throws IOException {
        this();
        this.read(file, filter, 1);
    }

    public MatFileReader() {
        this.data = new LinkedHashMap<String, MLArray>();
    }

    public synchronized Map<String, MLArray> read(File file) throws IOException {
        return this.read(file, new MatFileFilter(), 1);
    }

    public synchronized Map<String, MLArray> read(File file, int policy) throws IOException {
        return this.read(file, new MatFileFilter(), policy);
    }

    public synchronized Map<String, MLArray> read(File file, MatFileFilter filter, int policy) throws IOException {
        Map<String, MLArray> filesize2;
        WeakReference<MappedByteBuffer> bufferWeakRef;
        ByteBuffer buf;
        RandomAccessFile raFile;
        block24: {
            this.filter = filter;
            for (String key : this.data.keySet()) {
                this.data.remove(key);
            }
            FileChannel roChannel = null;
            raFile = null;
            buf = null;
            bufferWeakRef = null;
            try {
                raFile = new RandomAccessFile(file, "r");
                roChannel = raFile.getChannel();
                switch (policy) {
                    case 2: {
                        buf = ByteBuffer.allocateDirect((int)roChannel.size());
                        roChannel.read(buf, 0L);
                        buf.rewind();
                        break;
                    }
                    case 4: {
                        int filesize2 = (int)roChannel.size();
                        System.gc();
                        buf = ByteBuffer.allocate(filesize2);
                        int numberOfBlocks = filesize2 / 0x2000000 + (filesize2 % 0x2000000 > 0 ? 1 : 0);
                        if (numberOfBlocks > 1) {
                            ByteBuffer tempByteBuffer = ByteBuffer.allocateDirect(0x2000000);
                            for (int block = 0; block < numberOfBlocks; ++block) {
                                tempByteBuffer.clear();
                                roChannel.read(tempByteBuffer, block * 0x2000000);
                                tempByteBuffer.flip();
                                buf.put(tempByteBuffer);
                            }
                            tempByteBuffer = null;
                        } else {
                            roChannel.read(buf, 0L);
                        }
                        buf.rewind();
                        break;
                    }
                    case 1: {
                        buf = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                        bufferWeakRef = new WeakReference<MappedByteBuffer>((MappedByteBuffer)buf);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown file allocation policy");
                    }
                }
                this.readHeader(buf);
                while (buf.remaining() > 0) {
                    this.readData(buf);
                }
                filesize2 = this.getContent();
                Object var13_14 = null;
                if (roChannel == null) break block24;
            }
            catch (IOException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    if (roChannel != null) {
                        roChannel.close();
                    }
                    if (raFile != null) {
                        raFile.close();
                    }
                    if (buf != null && bufferWeakRef != null && policy == 1) {
                        try {
                            this.clean(buf);
                        }
                        catch (Exception e2) {
                            int GC_TIMEOUT_MS = 1000;
                            buf = null;
                            long start = System.currentTimeMillis();
                            while (bufferWeakRef.get() != null && System.currentTimeMillis() - start <= (long)GC_TIMEOUT_MS) {
                                System.gc();
                                Thread.yield();
                            }
                        }
                    }
                    throw throwable;
                }
            }
            roChannel.close();
        }
        if (raFile != null) {
            raFile.close();
        }
        if (buf != null && bufferWeakRef != null && policy == 1) {
            try {
                this.clean(buf);
            }
            catch (Exception e2) {
                int GC_TIMEOUT_MS = 1000;
                buf = null;
                long start = System.currentTimeMillis();
                while (bufferWeakRef.get() != null && System.currentTimeMillis() - start <= (long)GC_TIMEOUT_MS) {
                    System.gc();
                    Thread.yield();
                }
            }
        }
        return filesize2;
    }

    private void clean(final Object buffer) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                    getCleanerMethod.setAccessible(true);
                    Cleaner cleaner = (Cleaner)getCleanerMethod.invoke(buffer, new Object[0]);
                    cleaner.clean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public MatFileHeader getMatFileHeader() {
        return this.matFileHeader;
    }

    public ArrayList<MLArray> getData() {
        return new ArrayList<MLArray>(this.data.values());
    }

    public MLArray getMLArray(String name) {
        return this.data.get(name);
    }

    public Map<String, MLArray> getContent() {
        return this.data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readData(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        switch (tag.type) {
            case 15: {
                int numOfBytes = tag.size;
                if (buf.remaining() < numOfBytes) {
                    throw new MatlabIOException("Compressed buffer length miscalculated!");
                }
                InflaterInputStream iis = new InflaterInputStream(new ByteBufferInputStream(buf, numOfBytes));
                byte[] result = new byte[1024];
                HeapBufferDataOutputStream dos = new HeapBufferDataOutputStream();
                try {
                    try {
                        int i;
                        do {
                            i = iis.read(result, 0, result.length);
                            int len = Math.max(0, i);
                            dos.write(result, 0, len);
                        } while (i > 0);
                    }
                    catch (IOException e) {
                        throw new MatlabIOException("Could not decompress data: " + e);
                    }
                    Object var10_11 = null;
                    iis.close();
                    dos.flush();
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    iis.close();
                    dos.flush();
                    throw throwable;
                }
                ByteBuffer out = dos.getByteBuffer();
                out.order(this.byteOrder);
                try {
                    this.readData(out);
                    Object var12_17 = null;
                    dos.close();
                    return;
                }
                catch (Throwable throwable) {
                    Object var12_18 = null;
                    dos.close();
                    throw throwable;
                }
            }
            case 14: {
                int toread;
                int red;
                int pos = buf.position();
                MLArray element = this.readMatrix(buf, true);
                if (element != null && !this.data.containsKey(element.getName())) {
                    this.data.put(element.getName(), element);
                } else {
                    red = buf.position() - pos;
                    toread = tag.size - red;
                    buf.position(buf.position() + toread);
                }
                red = buf.position() - pos;
                toread = tag.size - red;
                if (toread == 0) return;
                throw new MatlabIOException("Matrix was not red fully! " + toread + " remaining in the buffer.");
            }
        }
        throw new MatlabIOException("Incorrect data tag: " + tag);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MLArray readMatrix(ByteBuffer buf, boolean isRoot) throws IOException {
        int[] flags = this.readFlags(buf);
        int attributes = flags.length != 0 ? flags[0] : 0;
        int nzmax = flags.length != 0 ? flags[1] : 0;
        int type = attributes & 0xFF;
        int[] dims = this.readDimension(buf);
        String name = this.readName(buf);
        if (isRoot && !this.filter.matches(name)) {
            return null;
        }
        switch (type) {
            case 2: {
                MLStructure struct = new MLStructure(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                int maxlen = buf.getInt();
                tag = new ISMatTag(buf);
                int numOfFields = tag.size / maxlen;
                String[] fieldNames = new String[numOfFields];
                for (int i = 0; i < numOfFields; ++i) {
                    byte[] names = new byte[maxlen];
                    buf.get(names);
                    fieldNames[i] = this.zeroEndByteArrayToString(names);
                }
                buf.position(buf.position() + tag.padding);
                int index = 0;
                while (true) {
                    if (index >= struct.getM() * struct.getN()) {
                        return struct;
                    }
                    for (int i = 0; i < numOfFields; ++i) {
                        tag = new ISMatTag(buf);
                        if (tag.size > 0) {
                            MLArray fieldValue = this.readMatrix(buf, false);
                            struct.setField(fieldNames[i], fieldValue, index);
                            continue;
                        }
                        struct.setField(fieldNames[i], new MLEmptyArray(), index);
                    }
                    ++index;
                }
            }
            case 1: {
                MLCell cell = new MLCell(name, dims, type, attributes);
                int i = 0;
                while (true) {
                    if (i >= cell.getM() * cell.getN()) {
                        return cell;
                    }
                    ISMatTag tag = new ISMatTag(buf);
                    if (tag.size > 0) {
                        MLArray cellmatrix = this.readMatrix(buf, false);
                        cell.set(cellmatrix, i);
                    } else {
                        cell.set(new MLEmptyArray(), i);
                    }
                    ++i;
                }
            }
            case 6: {
                MLArray mlArray = new MLDouble(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 7: {
                MLArray mlArray = new MLSingle(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 9: {
                MLArray mlArray = new MLUInt8(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 8: {
                MLArray mlArray = new MLInt8(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 10: {
                MLArray mlArray = new MLInt16(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 12: {
                MLArray mlArray = new MLInt32(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 13: {
                MLArray mlArray = new MLUInt32(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 14: {
                MLArray mlArray = new MLInt64(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 15: {
                MLArray mlArray = new MLUInt64(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 4: {
                MLChar mlchar = new MLChar(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                String str = tag.readToString();
                int i = 0;
                while (true) {
                    if (i >= str.length()) {
                        return mlchar;
                    }
                    mlchar.setChar(str.charAt(i), i);
                    ++i;
                }
            }
            case 5: {
                MLSparse sparse = new MLSparse(name, dims, attributes, nzmax);
                ISMatTag tag = new ISMatTag(buf);
                int[] ir = tag.readToIntArray();
                tag = new ISMatTag(buf);
                int[] jc = tag.readToIntArray();
                tag = new ISMatTag(buf);
                double[] ad1 = tag.readToDoubleArray();
                int count = 0;
                for (int column = 0; column < sparse.getN(); ++column) {
                    while (count < jc[column + 1]) {
                        sparse.setReal(ad1[count], ir[count], column);
                        ++count;
                    }
                }
                if (!sparse.isComplex()) return sparse;
                tag = new ISMatTag(buf);
                double[] ad2 = tag.readToDoubleArray();
                count = 0;
                int column = 0;
                while (column < sparse.getN()) {
                    while (count < jc[column + 1]) {
                        sparse.setImaginary(ad2[count], ir[count], column);
                        ++count;
                    }
                    ++column;
                }
                return sparse;
            }
            case 17: {
                MLArray mlArray;
                ISMatTag tag = new ISMatTag(buf);
                String className = tag.readToString();
                byte[] nn = new byte[dims.length];
                for (int i = 0; i < dims.length; ++i) {
                    nn[i] = (byte)dims[i];
                }
                String arrName = new String(nn);
                ISMatTag contentTag = new ISMatTag(buf);
                if (contentTag.type != 14) throw new IOException("Unexpected java object content");
                MLUInt8 content = (MLUInt8)this.readMatrix(buf, false);
                ObjectInputStream ois = new ObjectInputStream(new ByteBufferInputStream(content.getRealByteBuffer(), content.getRealByteBuffer().limit()));
                try {
                    try {
                        Object o = ois.readObject();
                        mlArray = new MLJavaObject(arrName, className, o);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    Object var31_65 = null;
                    ois.close();
                    return mlArray;
                }
                catch (Throwable throwable) {
                    Object var31_66 = null;
                    ois.close();
                    throw throwable;
                }
            }
            case 3: {
                ISMatTag tag = new ISMatTag(buf);
                String className = tag.readToString();
                MLStructure struct = new MLStructure(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                int maxlen = buf.getInt();
                tag = new ISMatTag(buf);
                int numOfFields = tag.size / maxlen;
                String[] fieldNames = new String[numOfFields];
                for (int i = 0; i < numOfFields; ++i) {
                    byte[] names = new byte[maxlen];
                    buf.get(names);
                    fieldNames[i] = this.zeroEndByteArrayToString(names);
                }
                buf.position(buf.position() + tag.padding);
                int index = 0;
                while (index < 1) {
                    for (int i = 0; i < numOfFields; ++i) {
                        tag = new ISMatTag(buf);
                        if (tag.size > 0) {
                            MLArray fieldValue = this.readMatrix(buf, false);
                            struct.setField(fieldNames[i], fieldValue, index);
                            continue;
                        }
                        struct.setField(fieldNames[i], new MLEmptyArray(), index);
                    }
                    ++index;
                }
                return new MLObject(name, className, struct);
            }
        }
        throw new MatlabIOException("Incorrect matlab array class: " + MLArray.typeToString(type));
    }

    private String zeroEndByteArrayToString(byte[] bytes) throws IOException {
        int i = 0;
        for (i = 0; i < bytes.length && bytes[i] != 0; ++i) {
        }
        return new String(bytes, 0, i);
    }

    private int[] readFlags(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] flags = tag.readToIntArray();
        return flags;
    }

    private int[] readDimension(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] dims = tag.readToIntArray();
        return dims;
    }

    private String readName(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        return tag.readToString();
    }

    private void readHeader(ByteBuffer buf) throws IOException {
        int version;
        byte[] endianIndicator = new byte[2];
        byte[] descriptionBuffer = new byte[116];
        buf.get(descriptionBuffer);
        String description = this.zeroEndByteArrayToString(descriptionBuffer);
        if (!description.matches("MATLAB 5.0 MAT-file.*")) {
            throw new MatlabIOException("This is not a valid MATLAB 5.0 MAT-file.");
        }
        buf.position(buf.position() + 8);
        byte[] bversion = new byte[2];
        buf.get(bversion);
        buf.get(endianIndicator);
        if ((char)endianIndicator[0] == 'I' && (char)endianIndicator[1] == 'M') {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            version = bversion[1] & 0xFF | bversion[0] << 8;
        } else {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            version = bversion[0] & 0xFF | bversion[1] << 8;
        }
        buf.order(this.byteOrder);
        this.matFileHeader = new MatFileHeader(description, version, endianIndicator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ISMatTag
    extends MatTag {
        private final MatFileInputStream mfis;
        private final int padding;
        private final boolean compressed;

        public ISMatTag(ByteBuffer buf) throws IOException {
            super(0, 0);
            int tmp = buf.getInt();
            if (tmp >> 16 == 0) {
                this.type = tmp;
                this.size = buf.getInt();
                this.compressed = false;
            } else {
                this.size = tmp >> 16;
                this.type = tmp & 0xFFFF;
                this.compressed = true;
            }
            this.padding = this.getPadding(this.size, this.compressed);
            this.mfis = new MatFileInputStream(buf, this.type);
        }

        public void readToByteBuffer(ByteBuffer buff, ByteStorageSupport<?> storage) throws IOException {
            int elements = this.size / this.sizeOf();
            this.mfis.readToByteBuffer(buff, elements, storage);
            this.mfis.skip(this.padding);
        }

        public byte[] readToByteArray() throws IOException {
            int elements = this.size / this.sizeOf();
            byte[] ab = new byte[elements];
            for (int i = 0; i < elements; ++i) {
                ab[i] = this.mfis.readByte();
            }
            this.mfis.skip(this.padding);
            return ab;
        }

        public double[] readToDoubleArray() throws IOException {
            int elements = this.size / this.sizeOf();
            double[] ad = new double[elements];
            for (int i = 0; i < elements; ++i) {
                ad[i] = this.mfis.readDouble();
            }
            this.mfis.skip(this.padding);
            return ad;
        }

        public int[] readToIntArray() throws IOException {
            int elements = this.size / this.sizeOf();
            int[] ai = new int[elements];
            for (int i = 0; i < elements; ++i) {
                ai[i] = this.mfis.readInt();
            }
            this.mfis.skip(this.padding);
            return ai;
        }

        public String readToString() throws IOException {
            byte[] bytes = this.readToByteArray();
            return new String(bytes, "UTF-8");
        }

        public char[] readToCharArray() throws IOException {
            int elements = this.size / this.sizeOf();
            char[] ac = new char[elements];
            for (int i = 0; i < elements; ++i) {
                ac[i] = this.mfis.readChar();
            }
            this.mfis.skip(this.padding);
            return ac;
        }
    }
}

