/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.hslf.blip.Bitmap;
import org.apache.poi.hslf.model.Fill;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.usermodel.PictureData;

public final class Background
extends Shape {
    protected Background(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        return null;
    }

    @Override
    public void draw(Graphics2D graphics) {
        Fill f = this.getFill();
        Dimension pg = this.getSheet().getSlideShow().getPageSize();
        Rectangle anchor = new Rectangle(0, 0, pg.width, pg.height);
        switch (f.getFillType()) {
            case 0: {
                Color color = f.getForegroundColor();
                graphics.setPaint(color);
                graphics.fill(anchor);
                break;
            }
            case 3: {
                PictureData data = f.getPictureData();
                if (!(data instanceof Bitmap)) break;
                BufferedImage img = null;
                try {
                    img = ImageIO.read(new ByteArrayInputStream(data.getData()));
                }
                catch (Exception e) {
                    this.logger.log(5, "ImageIO failed to create image. image.type: " + data.getType());
                    return;
                }
                Image scaledImg = img.getScaledInstance(anchor.width, anchor.height, 4);
                graphics.drawImage(scaledImg, anchor.x, anchor.y, null);
                break;
            }
            default: {
                this.logger.log(5, "unsuported fill type: " + f.getFillType());
            }
        }
    }
}

