/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class MessageSubmissionChunk
extends Chunk {
    private static POILogger logger = POILogFactory.getLogger(MessageSubmissionChunk.class);
    private String rawId;
    private Calendar date;
    private static final Pattern datePatern = Pattern.compile("(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)Z?");

    public MessageSubmissionChunk(String namePrefix, int chunkId, Types.MAPIType type) {
        super(namePrefix, chunkId, type);
    }

    public MessageSubmissionChunk(int chunkId, Types.MAPIType type) {
        super(chunkId, type);
    }

    @Override
    public void readValue(InputStream value) throws IOException {
        String[] parts;
        try {
            byte[] data = IOUtils.toByteArray(value);
            this.rawId = new String(data, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Core encoding not found, JVM broken?", e);
        }
        for (String part : parts = this.rawId.split(";")) {
            if (!part.startsWith("l=") || part.indexOf(45) == -1 || part.indexOf(45) == part.lastIndexOf(45)) continue;
            String dateS = part.substring(part.indexOf(45) + 1, part.lastIndexOf(45));
            Matcher m = datePatern.matcher(dateS);
            if (m.matches()) {
                this.date = Calendar.getInstance();
                this.date.set(1, Integer.parseInt(m.group(1)) + 2000);
                this.date.set(2, Integer.parseInt(m.group(2)) - 1);
                this.date.set(5, Integer.parseInt(m.group(3)));
                this.date.set(11, Integer.parseInt(m.group(4)));
                this.date.set(12, Integer.parseInt(m.group(5)));
                this.date.set(13, Integer.parseInt(m.group(6)));
                this.date.set(14, 0);
                continue;
            }
            logger.log(5, "Warning - unable to make sense of date " + dateS);
        }
    }

    @Override
    public void writeValue(OutputStream out) throws IOException {
        try {
            byte[] data = this.rawId.getBytes("ASCII");
            out.write(data);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Core encoding not found, JVM broken?", e);
        }
    }

    public Calendar getAcceptedAtTime() {
        return this.date;
    }

    public String getSubmissionId() {
        return this.rawId;
    }
}

