/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.util.Internal;
import org.apache.poi.xslf.model.PropertyFetcher;
import org.apache.poi.xslf.model.geom.Context;
import org.apache.poi.xslf.model.geom.CustomGeometry;
import org.apache.poi.xslf.model.geom.Guide;
import org.apache.poi.xslf.model.geom.IAdjustableShape;
import org.apache.poi.xslf.model.geom.Outline;
import org.apache.poi.xslf.model.geom.Path;
import org.apache.poi.xslf.usermodel.LineCap;
import org.apache.poi.xslf.usermodel.LineDash;
import org.apache.poi.xslf.usermodel.XSLFColor;
import org.apache.poi.xslf.usermodel.XSLFImageRenderer;
import org.apache.poi.xslf.usermodel.XSLFRenderingHint;
import org.apache.poi.xslf.usermodel.XSLFShadow;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuide;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNoFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPathShadeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.STPathShadeType;

@Internal
class RenderableShape {
    public static final Color NO_PAINT = new Color(255, 255, 255, 0);
    private XSLFSimpleShape _shape;

    public RenderableShape(XSLFSimpleShape shape) {
        this._shape = shape;
    }

    public Paint selectPaint(Graphics2D graphics, XmlObject obj, CTSchemeColor phClr, PackagePart parentPart) {
        XSLFTheme theme = this._shape.getSheet().getTheme();
        Paint paint = null;
        if (obj instanceof CTNoFillProperties) {
            paint = NO_PAINT;
        } else if (obj instanceof CTSolidColorFillProperties) {
            CTSolidColorFillProperties solidFill = (CTSolidColorFillProperties)obj;
            XSLFColor c = new XSLFColor(solidFill, theme, phClr);
            paint = c.getColor();
        } else if (obj instanceof CTBlipFillProperties) {
            CTBlipFillProperties blipFill = (CTBlipFillProperties)obj;
            paint = this.createTexturePaint(blipFill, graphics, parentPart);
        } else if (obj instanceof CTGradientFillProperties) {
            Rectangle2D anchor = this.getAnchor(graphics);
            CTGradientFillProperties gradFill = (CTGradientFillProperties)obj;
            if (gradFill.isSetLin()) {
                paint = this.createLinearGradientPaint(graphics, gradFill, anchor, theme, phClr);
            } else if (gradFill.isSetPath()) {
                CTPathShadeProperties ps = gradFill.getPath();
                if (ps.getPath() == STPathShadeType.CIRCLE) {
                    paint = RenderableShape.createRadialGradientPaint(gradFill, anchor, theme, phClr);
                } else if (ps.getPath() == STPathShadeType.SHAPE) {
                    paint = RenderableShape.toRadialGradientPaint(gradFill, anchor, theme, phClr);
                }
            }
        }
        return paint;
    }

    private Paint createTexturePaint(CTBlipFillProperties blipFill, Graphics2D graphics, PackagePart parentPart) {
        TexturePaint paint = null;
        CTBlip blip = blipFill.getBlip();
        String blipId = blip.getEmbed();
        PackageRelationship rel = parentPart.getRelationship(blipId);
        if (rel != null) {
            XSLFImageRenderer renderer = null;
            if (graphics != null) {
                renderer = (XSLFImageRenderer)graphics.getRenderingHint(XSLFRenderingHint.IMAGE_RENDERER);
            }
            if (renderer == null) {
                renderer = new XSLFImageRenderer();
            }
            try {
                BufferedImage img = renderer.readImage(parentPart.getRelatedPart(rel));
                if (blip.sizeOfAlphaModFixArray() > 0) {
                    float alpha = (float)blip.getAlphaModFixArray(0).getAmt() / 100000.0f;
                    AlphaComposite ac = AlphaComposite.getInstance(3, alpha);
                    if (graphics != null) {
                        graphics.setComposite(ac);
                    }
                }
                if (img != null) {
                    paint = new TexturePaint(img, new Rectangle2D.Double(0.0, 0.0, img.getWidth(), img.getHeight()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return paint;
    }

    private Paint createLinearGradientPaint(Graphics2D graphics, CTGradientFillProperties gradFill, Rectangle2D anchor, XSLFTheme theme, CTSchemeColor phClr) {
        Paint paint;
        double rotation;
        double angle = gradFill.getLin().getAng() / 60000;
        CTGradientStop[] gs = gradFill.getGsLst().getGsArray();
        Arrays.sort(gs, new Comparator<CTGradientStop>(){

            @Override
            public int compare(CTGradientStop o1, CTGradientStop o2) {
                Integer pos1 = o1.getPos();
                Integer pos2 = o2.getPos();
                return pos1.compareTo(pos2);
            }
        });
        Color[] colors = new Color[gs.length];
        float[] fractions = new float[gs.length];
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(angle), anchor.getX() + anchor.getWidth() / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        double diagonal = Math.sqrt(anchor.getHeight() * anchor.getHeight() + anchor.getWidth() * anchor.getWidth());
        Point2D p1 = new Point2D.Double(anchor.getX() + anchor.getWidth() / 2.0 - diagonal / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        p1 = at.transform(p1, null);
        Point2D p2 = new Point2D.Double(anchor.getX() + anchor.getWidth(), anchor.getY() + anchor.getHeight() / 2.0);
        p2 = at.transform(p2, null);
        RenderableShape.snapToAnchor(p1, anchor);
        RenderableShape.snapToAnchor(p2, anchor);
        for (int i = 0; i < gs.length; ++i) {
            CTGradientStop stop = gs[i];
            colors[i] = new XSLFColor(stop, theme, phClr).getColor();
            fractions[i] = (float)stop.getPos() / 100000.0f;
        }
        AffineTransform grAt = new AffineTransform();
        if ((gradFill.isSetRotWithShape() || !gradFill.getRotWithShape()) && (rotation = this._shape.getRotation()) != 0.0) {
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            grAt.translate(centerX, centerY);
            grAt.rotate(Math.toRadians(-rotation));
            grAt.translate(-centerX, -centerY);
        }
        try {
            Class<?> clz = Class.forName("java.awt.LinearGradientPaint");
            Class<?> clzCycleMethod = Class.forName("java.awt.MultipleGradientPaint$CycleMethod");
            Class<?> clzColorSpaceType = Class.forName("java.awt.MultipleGradientPaint$ColorSpaceType");
            Constructor<?> c = clz.getConstructor(Point2D.class, Point2D.class, float[].class, Color[].class, clzCycleMethod, clzColorSpaceType, AffineTransform.class);
            paint = (Paint)c.newInstance(p1, p2, fractions, colors, Enum.valueOf(clzCycleMethod, "NO_CYCLE"), Enum.valueOf(clzColorSpaceType, "SRGB"), grAt);
        }
        catch (ClassNotFoundException e) {
            paint = new GradientPaint(p1, colors[0], p2, colors[colors.length - 1]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return paint;
    }

    private static Paint toRadialGradientPaint(CTGradientFillProperties gradFill, Rectangle2D anchor, XSLFTheme theme, CTSchemeColor phClr) {
        CTGradientStop[] gs = gradFill.getGsLst().getGsArray();
        Arrays.sort(gs, new Comparator<CTGradientStop>(){

            @Override
            public int compare(CTGradientStop o1, CTGradientStop o2) {
                Integer pos1 = o1.getPos();
                Integer pos2 = o2.getPos();
                return pos1.compareTo(pos2);
            }
        });
        gs[1].setPos(50000);
        CTGradientFillProperties g = CTGradientFillProperties.Factory.newInstance();
        g.set(gradFill);
        g.getGsLst().setGsArray(new CTGradientStop[]{gs[0], gs[1]});
        return RenderableShape.createRadialGradientPaint(g, anchor, theme, phClr);
    }

    private static Paint createRadialGradientPaint(CTGradientFillProperties gradFill, Rectangle2D anchor, XSLFTheme theme, CTSchemeColor phClr) {
        Paint paint;
        CTGradientStop[] gs = gradFill.getGsLst().getGsArray();
        Point2D.Double pCenter = new Point2D.Double(anchor.getX() + anchor.getWidth() / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        float radius = (float)Math.max(anchor.getWidth(), anchor.getHeight());
        Arrays.sort(gs, new Comparator<CTGradientStop>(){

            @Override
            public int compare(CTGradientStop o1, CTGradientStop o2) {
                Integer pos1 = o1.getPos();
                Integer pos2 = o2.getPos();
                return pos1.compareTo(pos2);
            }
        });
        Color[] colors = new Color[gs.length];
        float[] fractions = new float[gs.length];
        for (int i = 0; i < gs.length; ++i) {
            CTGradientStop stop = gs[i];
            colors[i] = new XSLFColor(stop, theme, phClr).getColor();
            fractions[i] = (float)stop.getPos() / 100000.0f;
        }
        try {
            Class<?> clz = Class.forName("java.awt.RadialGradientPaint");
            Constructor<?> c = clz.getConstructor(Point2D.class, Float.TYPE, float[].class, Color[].class);
            paint = (Paint)c.newInstance(pCenter, Float.valueOf(radius), fractions, colors);
        }
        catch (ClassNotFoundException e) {
            paint = new GradientPaint(new Point2D.Double(anchor.getX(), anchor.getY()), colors[0], pCenter, colors[colors.length - 1]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return paint;
    }

    private static void snapToAnchor(Point2D p, Rectangle2D anchor) {
        if (p.getX() < anchor.getX()) {
            p.setLocation(anchor.getX(), p.getY());
        } else if (p.getX() > anchor.getX() + anchor.getWidth()) {
            p.setLocation(anchor.getX() + anchor.getWidth(), p.getY());
        }
        if (p.getY() < anchor.getY()) {
            p.setLocation(p.getX(), anchor.getY());
        } else if (p.getY() > anchor.getY() + anchor.getHeight()) {
            p.setLocation(p.getX(), anchor.getY() + anchor.getHeight());
        }
    }

    Paint getPaint(Graphics2D graphics, XmlObject spPr, CTSchemeColor phClr) {
        XmlObject obj;
        Paint paint = null;
        XmlObject[] arr$ = spPr.selectPath("*");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (paint = this.selectPaint(graphics, obj = arr$[i$], phClr, this._shape.getSheet().getPackagePart())) == null; ++i$) {
        }
        return paint == NO_PAINT ? null : paint;
    }

    Paint getFillPaint(final Graphics2D graphics) {
        CTShapeStyle style;
        PropertyFetcher<Paint> fetcher = new PropertyFetcher<Paint>(){

            @Override
            public boolean fetch(XSLFSimpleShape shape) {
                CTShapeProperties spPr = shape.getSpPr();
                if (spPr.isSetNoFill()) {
                    this.setValue(NO_PAINT);
                    return true;
                }
                Paint paint = RenderableShape.this.getPaint(graphics, spPr, null);
                if (paint != null) {
                    this.setValue(paint);
                    return true;
                }
                return false;
            }
        };
        this._shape.fetchShapeProperty(fetcher);
        Paint paint = (Paint)fetcher.getValue();
        if (paint == null && (style = this._shape.getSpStyle()) != null) {
            CTStyleMatrixReference fillRef = style.getFillRef();
            int idx = (int)fillRef.getIdx();
            CTSchemeColor phClr = fillRef.getSchemeClr();
            XSLFSheet sheet = this._shape.getSheet();
            XSLFTheme theme = sheet.getTheme();
            XmlObject fillProps = null;
            if (idx >= 1 && idx <= 999) {
                fillProps = theme.getXmlObject().getThemeElements().getFmtScheme().getFillStyleLst().selectPath("*")[idx - 1];
            } else if (idx >= 1001) {
                fillProps = theme.getXmlObject().getThemeElements().getFmtScheme().getBgFillStyleLst().selectPath("*")[idx - 1001];
            }
            if (fillProps != null) {
                paint = this.selectPaint(graphics, fillProps, phClr, sheet.getPackagePart());
            }
        }
        return paint == NO_PAINT ? null : paint;
    }

    public Paint getLinePaint(final Graphics2D graphics) {
        CTShapeStyle style;
        PropertyFetcher<Paint> fetcher = new PropertyFetcher<Paint>(){

            @Override
            public boolean fetch(XSLFSimpleShape shape) {
                CTLineProperties spPr = shape.getSpPr().getLn();
                if (spPr != null) {
                    if (spPr.isSetNoFill()) {
                        this.setValue(NO_PAINT);
                        return true;
                    }
                    Paint paint = RenderableShape.this.getPaint(graphics, spPr, null);
                    if (paint != null) {
                        this.setValue(paint);
                        return true;
                    }
                }
                return false;
            }
        };
        this._shape.fetchShapeProperty(fetcher);
        Paint paint = (Paint)fetcher.getValue();
        if (paint == null && (style = this._shape.getSpStyle()) != null) {
            CTStyleMatrixReference lnRef = style.getLnRef();
            int idx = (int)lnRef.getIdx();
            CTSchemeColor phClr = lnRef.getSchemeClr();
            if (idx > 0) {
                XSLFTheme theme = this._shape.getSheet().getTheme();
                XmlObject lnProps = theme.getXmlObject().getThemeElements().getFmtScheme().getLnStyleLst().selectPath("*")[idx - 1];
                paint = this.getPaint(graphics, lnProps, phClr);
            }
        }
        return paint == NO_PAINT ? null : paint;
    }

    private static float[] getDashPattern(LineDash lineDash, float lineWidth) {
        float[] dash = null;
        switch (lineDash) {
            case SYS_DOT: {
                dash = new float[]{lineWidth, lineWidth};
                break;
            }
            case SYS_DASH: {
                dash = new float[]{2.0f * lineWidth, 2.0f * lineWidth};
                break;
            }
            case DASH: {
                dash = new float[]{3.0f * lineWidth, 4.0f * lineWidth};
                break;
            }
            case DASH_DOT: {
                dash = new float[]{4.0f * lineWidth, 3.0f * lineWidth, lineWidth, 3.0f * lineWidth};
                break;
            }
            case LG_DASH: {
                dash = new float[]{8.0f * lineWidth, 3.0f * lineWidth};
                break;
            }
            case LG_DASH_DOT: {
                dash = new float[]{8.0f * lineWidth, 3.0f * lineWidth, lineWidth, 3.0f * lineWidth};
                break;
            }
            case LG_DASH_DOT_DOT: {
                dash = new float[]{8.0f * lineWidth, 3.0f * lineWidth, lineWidth, 3.0f * lineWidth, lineWidth, 3.0f * lineWidth};
            }
        }
        return dash;
    }

    public Stroke applyStroke(Graphics2D graphics) {
        float lineWidth = (float)this._shape.getLineWidth();
        if (lineWidth == 0.0f) {
            lineWidth = 0.25f;
        }
        LineDash lineDash = this._shape.getLineDash();
        float[] dash = null;
        float dash_phase = 0.0f;
        if (lineDash != null) {
            dash = RenderableShape.getDashPattern(lineDash, lineWidth);
        }
        int cap = 0;
        LineCap lineCap = this._shape.getLineCap();
        if (lineCap != null) {
            switch (lineCap) {
                case ROUND: {
                    cap = 1;
                    break;
                }
                case SQUARE: {
                    cap = 2;
                    break;
                }
                default: {
                    cap = 0;
                }
            }
        }
        int meter = 1;
        BasicStroke stroke = new BasicStroke(lineWidth, cap, meter, Math.max(1.0f, lineWidth), dash, dash_phase);
        graphics.setStroke(stroke);
        return stroke;
    }

    public void render(Graphics2D graphics) {
        Collection<Outline> elems = this.computeOutlines(graphics);
        XSLFShadow shadow = this._shape.getShadow();
        Paint fill = this.getFillPaint(graphics);
        Paint line = this.getLinePaint(graphics);
        this.applyStroke(graphics);
        if (shadow != null) {
            for (Outline o : elems) {
                if (!o.getPath().isFilled()) continue;
                if (fill != null) {
                    shadow.fill(graphics, o.getOutline());
                    continue;
                }
                if (line == null) continue;
                shadow.draw(graphics, o.getOutline());
            }
        }
        if (fill != null) {
            for (Outline o : elems) {
                if (!o.getPath().isFilled()) continue;
                graphics.setPaint(fill);
                graphics.fill(o.getOutline());
            }
        }
        this._shape.drawContent(graphics);
        if (line != null) {
            for (Outline o : elems) {
                if (!o.getPath().isStroked()) continue;
                graphics.setPaint(line);
                graphics.draw(o.getOutline());
            }
        }
    }

    private Collection<Outline> computeOutlines(Graphics2D graphics) {
        ArrayList<Outline> lst = new ArrayList<Outline>();
        CustomGeometry geom = this._shape.getGeometry();
        if (geom == null) {
            return lst;
        }
        Rectangle2D anchor = this.getAnchor(graphics);
        for (Path p : geom) {
            double w = p.getW() == -1L ? anchor.getWidth() * 12700.0 : (double)p.getW();
            double h = p.getH() == -1L ? anchor.getHeight() * 12700.0 : (double)p.getH();
            Rectangle2D.Double pathAnchor = new Rectangle2D.Double(0.0, 0.0, w, h);
            Context ctx = new Context(geom, pathAnchor, new IAdjustableShape(){

                @Override
                public Guide getAdjustValue(String name) {
                    CTPresetGeometry2D prst = RenderableShape.this._shape.getSpPr().getPrstGeom();
                    if (prst.isSetAvLst()) {
                        for (CTGeomGuide g : prst.getAvLst().getGdArray()) {
                            if (!g.getName().equals(name)) continue;
                            return new Guide(g);
                        }
                    }
                    return null;
                }
            });
            GeneralPath gp = p.getPath(ctx);
            AffineTransform at = new AffineTransform();
            at.translate(anchor.getX(), anchor.getY());
            double scaleX = p.getW() != -1L ? anchor.getWidth() / (double)p.getW() : 7.874015748031496E-5;
            double scaleY = p.getH() != -1L ? anchor.getHeight() / (double)p.getH() : 7.874015748031496E-5;
            at.scale(scaleX, scaleY);
            Shape canvasShape = at.createTransformedShape(gp);
            lst.add(new Outline(canvasShape, p));
        }
        return lst;
    }

    public Rectangle2D getAnchor(Graphics2D graphics) {
        Rectangle2D anchor = this._shape.getAnchor();
        if (graphics == null) {
            return anchor;
        }
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(XSLFRenderingHint.GROUP_TRANSFORM);
        if (tx != null) {
            anchor = tx.createTransformedShape(anchor).getBounds2D();
        }
        return anchor;
    }
}

