/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFAutoShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTAdjPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomRect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DClose;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DCubicBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DLineTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DMoveTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShapeNonVisual;

public class XSLFFreeformShape
extends XSLFAutoShape {
    XSLFFreeformShape(CTShape shape, XSLFSheet sheet) {
        super(shape, sheet);
    }

    public int setPath(GeneralPath path) {
        CTPath2D ctPath = CTPath2D.Factory.newInstance();
        Rectangle2D bounds = path.getBounds2D();
        int x0 = Units.toEMU(bounds.getX());
        int y0 = Units.toEMU(bounds.getY());
        PathIterator it = path.getPathIterator(new AffineTransform());
        int numPoints = 0;
        ctPath.setH(Units.toEMU(bounds.getHeight()));
        ctPath.setW(Units.toEMU(bounds.getWidth()));
        while (!it.isDone()) {
            double[] vals = new double[6];
            int type = it.currentSegment(vals);
            switch (type) {
                case 0: {
                    CTAdjPoint2D mv = ctPath.addNewMoveTo().addNewPt();
                    mv.setX(Units.toEMU(vals[0]) - x0);
                    mv.setY(Units.toEMU(vals[1]) - y0);
                    ++numPoints;
                    break;
                }
                case 1: {
                    CTAdjPoint2D ln = ctPath.addNewLnTo().addNewPt();
                    ln.setX(Units.toEMU(vals[0]) - x0);
                    ln.setY(Units.toEMU(vals[1]) - y0);
                    ++numPoints;
                    break;
                }
                case 3: {
                    CTPath2DCubicBezierTo bez = ctPath.addNewCubicBezTo();
                    CTAdjPoint2D p1 = bez.addNewPt();
                    p1.setX(Units.toEMU(vals[0]) - x0);
                    p1.setY(Units.toEMU(vals[1]) - y0);
                    CTAdjPoint2D p2 = bez.addNewPt();
                    p2.setX(Units.toEMU(vals[2]) - x0);
                    p2.setY(Units.toEMU(vals[3]) - y0);
                    CTAdjPoint2D p3 = bez.addNewPt();
                    p3.setX(Units.toEMU(vals[4]) - x0);
                    p3.setY(Units.toEMU(vals[5]) - y0);
                    numPoints += 3;
                    break;
                }
                case 4: {
                    ++numPoints;
                    ctPath.addNewClose();
                }
            }
            it.next();
        }
        this.getSpPr().getCustGeom().getPathLst().setPathArray(new CTPath2D[]{ctPath});
        this.setAnchor(bounds);
        return numPoints;
    }

    public GeneralPath getPath() {
        GeneralPath path = new GeneralPath();
        Rectangle2D bounds = this.getAnchor();
        CTCustomGeometry2D geom = this.getSpPr().getCustGeom();
        for (CTPath2D spPath : geom.getPathLst().getPathArray()) {
            double scaleW = bounds.getWidth() / Units.toPoints(spPath.getW());
            double scaleH = bounds.getHeight() / Units.toPoints(spPath.getH());
            for (XmlObject ch : spPath.selectPath("*")) {
                CTAdjPoint2D pt;
                if (ch instanceof CTPath2DMoveTo) {
                    pt = ((CTPath2DMoveTo)ch).getPt();
                    path.moveTo((float)(Units.toPoints((Long)pt.getX()) * scaleW), (float)(Units.toPoints((Long)pt.getY()) * scaleH));
                    continue;
                }
                if (ch instanceof CTPath2DLineTo) {
                    pt = ((CTPath2DLineTo)ch).getPt();
                    path.lineTo((float)Units.toPoints((Long)pt.getX()), (float)Units.toPoints((Long)pt.getY()));
                    continue;
                }
                if (ch instanceof CTPath2DCubicBezierTo) {
                    CTPath2DCubicBezierTo bez = (CTPath2DCubicBezierTo)ch;
                    CTAdjPoint2D pt1 = bez.getPtArray(0);
                    CTAdjPoint2D pt2 = bez.getPtArray(1);
                    CTAdjPoint2D pt3 = bez.getPtArray(2);
                    path.curveTo((float)(Units.toPoints((Long)pt1.getX()) * scaleW), (float)(Units.toPoints((Long)pt1.getY()) * scaleH), (float)(Units.toPoints((Long)pt2.getX()) * scaleW), (float)(Units.toPoints((Long)pt2.getY()) * scaleH), (float)(Units.toPoints((Long)pt3.getX()) * scaleW), (float)(Units.toPoints((Long)pt3.getY()) * scaleH));
                    continue;
                }
                if (!(ch instanceof CTPath2DClose)) continue;
                path.closePath();
            }
        }
        AffineTransform at = new AffineTransform();
        at.translate(bounds.getX(), bounds.getY());
        return new GeneralPath(at.createTransformedShape(path));
    }

    static CTShape prototype(int shapeId) {
        CTShape ct = CTShape.Factory.newInstance();
        CTShapeNonVisual nvSpPr = ct.addNewNvSpPr();
        CTNonVisualDrawingProps cnv = nvSpPr.addNewCNvPr();
        cnv.setName("Freeform " + shapeId);
        cnv.setId(shapeId + 1);
        nvSpPr.addNewCNvSpPr();
        nvSpPr.addNewNvPr();
        CTShapeProperties spPr = ct.addNewSpPr();
        CTCustomGeometry2D geom = spPr.addNewCustGeom();
        geom.addNewAvLst();
        geom.addNewGdLst();
        geom.addNewAhLst();
        geom.addNewCxnLst();
        CTGeomRect rect = geom.addNewRect();
        rect.setR("r");
        rect.setB("b");
        rect.setT("t");
        rect.setL("l");
        geom.addNewPathLst();
        return ct;
    }
}

