/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mail;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class MailContentHandler
implements ContentHandler {
    private boolean strictParsing = false;
    private XHTMLContentHandler handler;
    private ParseContext context;
    private Metadata metadata;
    private TikaConfig tikaConfig = null;
    private boolean inPart = false;

    MailContentHandler(XHTMLContentHandler xhtml, Metadata metadata, ParseContext context, boolean strictParsing) {
        this.handler = xhtml;
        this.context = context;
        this.metadata = metadata;
        this.strictParsing = strictParsing;
    }

    @Override
    public void body(BodyDescriptor body, InputStream is) throws MimeException, IOException {
        Parser parser = this.context.get(AutoDetectParser.class);
        if (parser == null) {
            parser = this.context.get(Parser.class);
        }
        if (parser == null) {
            if (this.tikaConfig == null) {
                this.tikaConfig = this.context.get(TikaConfig.class);
                if (this.tikaConfig == null) {
                    this.tikaConfig = TikaConfig.getDefaultConfig();
                }
            }
            parser = this.tikaConfig.getParser();
        }
        Metadata submd = new Metadata();
        submd.set("Content-Type", body.getMimeType());
        submd.set("Content-Encoding", body.getCharset());
        try {
            BodyContentHandler bch = new BodyContentHandler(this.handler);
            parser.parse(is, new EmbeddedContentHandler(bch), submd, this.context);
        }
        catch (SAXException e) {
            throw new MimeException(e);
        }
        catch (TikaException e) {
            throw new MimeException(e);
        }
    }

    @Override
    public void endBodyPart() throws MimeException {
        try {
            this.handler.endElement("p");
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new MimeException(e);
        }
    }

    @Override
    public void endHeader() throws MimeException {
    }

    @Override
    public void startMessage() throws MimeException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new MimeException(e);
        }
    }

    @Override
    public void endMessage() throws MimeException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new MimeException(e);
        }
    }

    @Override
    public void endMultipart() throws MimeException {
        this.inPart = false;
    }

    @Override
    public void epilogue(InputStream is) throws MimeException, IOException {
    }

    @Override
    public void field(Field field) throws MimeException {
        block19: {
            if (this.inPart) {
                return;
            }
            try {
                String fieldname = field.getName();
                ParsedField parsedField = LenientFieldParser.getParser().parse(field, DecodeMonitor.SILENT);
                if (fieldname.equalsIgnoreCase("From")) {
                    MailboxListField fromField = (MailboxListField)parsedField;
                    MailboxList mailboxList = fromField.getMailboxList();
                    if (fromField.isValidField() && mailboxList != null) {
                        for (Address address : mailboxList) {
                            String from = this.getDisplayString(address);
                            this.metadata.add("Message-From", from);
                            this.metadata.add(TikaCoreProperties.CREATOR, from);
                        }
                    } else {
                        String from = this.stripOutFieldPrefix(field, "From:");
                        if (from.startsWith("<")) {
                            from = from.substring(1);
                        }
                        if (from.endsWith(">")) {
                            from = from.substring(0, from.length() - 1);
                        }
                        this.metadata.add("Message-From", from);
                        this.metadata.add(TikaCoreProperties.CREATOR, from);
                    }
                } else if (fieldname.equalsIgnoreCase("Subject")) {
                    this.metadata.add(TikaCoreProperties.TRANSITION_SUBJECT_TO_DC_TITLE, ((UnstructuredField)parsedField).getValue());
                } else if (fieldname.equalsIgnoreCase("To")) {
                    this.processAddressList(parsedField, "To:", "Message-To");
                } else if (fieldname.equalsIgnoreCase("CC")) {
                    this.processAddressList(parsedField, "Cc:", "Message-Cc");
                } else if (fieldname.equalsIgnoreCase("BCC")) {
                    this.processAddressList(parsedField, "Bcc:", "Message-Bcc");
                } else if (fieldname.equalsIgnoreCase("Date")) {
                    DateTimeField dateField = (DateTimeField)parsedField;
                    this.metadata.set(TikaCoreProperties.CREATED, dateField.getDate());
                }
            }
            catch (RuntimeException me) {
                if (!this.strictParsing) break block19;
                throw me;
            }
        }
    }

    private void processAddressList(ParsedField field, String addressListType, String metadataField) throws MimeException {
        AddressListField toField = (AddressListField)field;
        if (toField.isValidField()) {
            AddressList addressList = toField.getAddressList();
            for (Address address : addressList) {
                this.metadata.add(metadataField, this.getDisplayString(address));
            }
        } else {
            String to = this.stripOutFieldPrefix(field, addressListType);
            for (String eachTo : to.split(",")) {
                this.metadata.add(metadataField, eachTo.trim());
            }
        }
    }

    private String getDisplayString(Address address) {
        if (address instanceof Mailbox) {
            Mailbox mailbox = (Mailbox)address;
            String name = mailbox.getName();
            if (name != null && name.length() > 0) {
                name = DecoderUtil.decodeEncodedWords(name, DecodeMonitor.SILENT);
                return name + " <" + mailbox.getAddress() + ">";
            }
            return mailbox.getAddress();
        }
        return address.toString();
    }

    @Override
    public void preamble(InputStream is) throws MimeException, IOException {
    }

    @Override
    public void raw(InputStream is) throws MimeException, IOException {
    }

    @Override
    public void startBodyPart() throws MimeException {
        try {
            this.handler.startElement("div", "class", "email-entry");
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new MimeException(e);
        }
    }

    @Override
    public void startHeader() throws MimeException {
    }

    @Override
    public void startMultipart(BodyDescriptor descr) throws MimeException {
        this.inPart = true;
    }

    private String stripOutFieldPrefix(Field field, String fieldname) {
        String temp = field.getRaw().toString();
        int loc = fieldname.length();
        while (temp.charAt(loc) == ' ') {
            ++loc;
        }
        return temp.substring(loc);
    }
}

