/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.pdf.PDF2XHTML;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PDFParser
extends AbstractParser {
    private static final MediaType MEDIA_TYPE = MediaType.application("pdf");
    private static final long serialVersionUID = -752276948656079347L;
    private PDFParserConfig defaultConfig = new PDFParserConfig();
    public static final String PASSWORD = "org.apache.tika.parser.pdf.password";
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        PDDocument pdfDocument = null;
        TemporaryResources tmp = new TemporaryResources();
        PDFParserConfig localConfig = context.get(PDFParserConfig.class, this.defaultConfig);
        String password = "";
        try {
            TikaInputStream tstream = TikaInputStream.cast(stream);
            password = this.getPassword(metadata, context);
            if (tstream != null && tstream.hasFile()) {
                RandomAccessFile scratchFile = new RandomAccessFile(tmp.createTemporaryFile(), "rw");
                pdfDocument = localConfig.getUseNonSequentialParser() ? PDDocument.loadNonSeq(new CloseShieldInputStream(stream), (RandomAccess)scratchFile, password) : PDDocument.load(new CloseShieldInputStream(stream), scratchFile, true);
            } else {
                pdfDocument = localConfig.getUseNonSequentialParser() ? PDDocument.loadNonSeq(new CloseShieldInputStream(stream), (RandomAccess)new RandomAccessBuffer(), password) : PDDocument.load((InputStream)new CloseShieldInputStream(stream), true);
            }
            metadata.set("pdf:encrypted", Boolean.toString(pdfDocument.isEncrypted()));
            if (!localConfig.getUseNonSequentialParser() && pdfDocument.isEncrypted()) {
                try {
                    pdfDocument.decrypt(password);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            metadata.set("Content-Type", "application/pdf");
            this.extractMetadata(pdfDocument, metadata);
            if (handler != null) {
                PDF2XHTML.process(pdfDocument, handler, context, metadata, localConfig);
            }
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
            tmp.dispose();
            PDFont.clearResources();
        }
    }

    private String getPassword(Metadata metadata, ParseContext context) {
        String password = null;
        PasswordProvider passwordProvider = context.get(PasswordProvider.class);
        if (passwordProvider != null) {
            password = passwordProvider.getPassword(metadata);
        }
        if (password == null && metadata.get(PASSWORD) != null) {
            password = metadata.get(PASSWORD);
        }
        if (password == null) {
            password = "";
        }
        return password;
    }

    private void extractMetadata(PDDocument document, Metadata metadata) throws TikaException {
        XMPMetadata xmp = null;
        XMPSchemaDublinCore dcSchema = null;
        try {
            if (document.getDocumentCatalog().getMetadata() != null) {
                xmp = document.getDocumentCatalog().getMetadata().exportXMPMetadata();
            }
            if (xmp != null) {
                dcSchema = xmp.getDublinCoreSchema();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        PDDocumentInformation info = document.getDocumentInformation();
        metadata.set(PagedText.N_PAGES, document.getNumberOfPages());
        this.extractMultilingualItems(metadata, TikaCoreProperties.TITLE, info.getTitle(), dcSchema);
        this.extractDublinCoreListItems(metadata, TikaCoreProperties.CREATOR, info.getAuthor(), dcSchema);
        this.extractDublinCoreListItems(metadata, TikaCoreProperties.CONTRIBUTOR, null, dcSchema);
        this.addMetadata(metadata, TikaCoreProperties.CREATOR_TOOL, info.getCreator());
        this.addMetadata(metadata, TikaCoreProperties.KEYWORDS, info.getKeywords());
        this.addMetadata(metadata, "producer", info.getProducer());
        this.extractMultilingualItems(metadata, TikaCoreProperties.DESCRIPTION, null, dcSchema);
        this.addMetadata(metadata, TikaCoreProperties.TRANSITION_SUBJECT_TO_OO_SUBJECT, info.getSubject());
        this.addMetadata(metadata, "trapped", info.getTrapped());
        try {
            this.addMetadata(metadata, "created", info.getCreationDate());
            this.addMetadata(metadata, TikaCoreProperties.CREATED, info.getCreationDate());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Calendar modified = info.getModificationDate();
            this.addMetadata(metadata, Metadata.LAST_MODIFIED, modified);
            this.addMetadata(metadata, TikaCoreProperties.MODIFIED, modified);
        }
        catch (IOException e) {
            // empty catch block
        }
        List<String> handledMetadata = Arrays.asList("Author", "Creator", "CreationDate", "ModDate", "Keywords", "Producer", "Subject", "Title", "Trapped");
        for (COSName key : info.getDictionary().keySet()) {
            String name = key.getName();
            if (handledMetadata.contains(name)) continue;
            this.addMetadata(metadata, name, info.getDictionary().getDictionaryObject(key));
        }
        metadata.set("pdf:PDFVersion", Float.toString(document.getDocument().getVersion()));
        metadata.add(TikaCoreProperties.FORMAT.getName(), MEDIA_TYPE.toString() + "; version=" + Float.toString(document.getDocument().getVersion()));
        try {
            if (xmp != null) {
                xmp.addXMLNSMapping("http://www.aiim.org/pdfa/ns/id/", XMPSchemaPDFAId.class);
                XMPSchemaPDFAId pdfaxmp = (XMPSchemaPDFAId)xmp.getSchemaByClass(XMPSchemaPDFAId.class);
                if (pdfaxmp != null) {
                    metadata.set("pdfaid:part", Integer.toString(pdfaxmp.getPart()));
                    if (pdfaxmp.getConformance() != null) {
                        metadata.set("pdfaid:conformance", pdfaxmp.getConformance());
                        String version = "A-" + pdfaxmp.getPart() + pdfaxmp.getConformance().toLowerCase(Locale.ROOT);
                        metadata.set("pdfa:PDFVersion", version);
                        metadata.add(TikaCoreProperties.FORMAT.getName(), MEDIA_TYPE.toString() + "; version=\"" + version + "\"");
                    }
                }
            }
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        COSDictionary root = document.getDocumentCatalog().getCOSDictionary();
        COSDictionary extensions = (COSDictionary)root.getDictionaryObject(COSName.getPDFName("Extensions"));
        if (extensions != null) {
            for (COSName extName : extensions.keySet()) {
                if (extName.equals(COSName.getPDFName("ADBE"))) {
                    COSDictionary adobeExt = (COSDictionary)extensions.getDictionaryObject(extName);
                    if (adobeExt == null) continue;
                    String baseVersion = adobeExt.getNameAsString(COSName.getPDFName("BaseVersion"));
                    int el = adobeExt.getInt(COSName.getPDFName("ExtensionLevel"));
                    if (el == -1) continue;
                    metadata.set("pdf:PDFExtensionVersion", baseVersion + " Adobe Extension Level " + el);
                    metadata.add(TikaCoreProperties.FORMAT.getName(), MEDIA_TYPE.toString() + "; version=\"" + baseVersion + " Adobe Extension Level " + el + "\"");
                    continue;
                }
                metadata.set("pdf:foundNonAdobeExtensionName", extName.getName());
            }
        }
    }

    private void extractMultilingualItems(Metadata metadata, Property property, String pdfBoxBaseline, XMPSchema schema) {
        if (schema == null) {
            if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
                metadata.set(property, pdfBoxBaseline);
            }
            return;
        }
        for (String lang : schema.getLanguagePropertyLanguages(property.getName())) {
            String value = schema.getLanguageProperty(property.getName(), lang);
            if (value == null || value.length() <= 0 || pdfBoxBaseline != null && value.equals(pdfBoxBaseline)) continue;
            metadata.add(property, value);
            if (property.isMultiValuePermitted()) continue;
            return;
        }
        if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
            if (!property.isMultiValuePermitted() && metadata.get(property) != null) {
                return;
            }
            metadata.add(property, pdfBoxBaseline);
        }
    }

    private void extractDublinCoreListItems(Metadata metadata, Property property, String pdfBoxBaseline, XMPSchemaDublinCore dc) {
        if (dc == null) {
            if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
                this.addMetadata(metadata, property, pdfBoxBaseline);
            }
            return;
        }
        List<String> items = this.getXMPBagOrSeqList(dc, property.getName());
        if (items == null) {
            if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
                this.addMetadata(metadata, property, pdfBoxBaseline);
            }
            return;
        }
        for (String item : items) {
            if (pdfBoxBaseline == null || item.equals(pdfBoxBaseline)) continue;
            this.addMetadata(metadata, property, item);
        }
        if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
            this.addMetadata(metadata, property, pdfBoxBaseline);
        }
    }

    private List<String> getXMPBagOrSeqList(XMPSchema schema, String name) {
        List<String> ret = schema.getBagList(name);
        if (ret == null) {
            ret = schema.getSequenceList(name);
        }
        return ret;
    }

    private void addMetadata(Metadata metadata, Property property, String value) {
        if (value != null) {
            metadata.add(property, value);
        }
    }

    private void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, value);
        }
    }

    private void addMetadata(Metadata metadata, String name, Calendar value) {
        if (value != null) {
            metadata.set(name, value.getTime().toString());
        }
    }

    private void addMetadata(Metadata metadata, Property property, Calendar value) {
        if (value != null) {
            metadata.set(property, value.getTime());
        }
    }

    private void addMetadata(Metadata metadata, String name, COSBase value) {
        if (value instanceof COSArray) {
            for (Object v : ((COSArray)value).toList()) {
                this.addMetadata(metadata, name, (COSBase)v);
            }
        } else if (value instanceof COSString) {
            this.addMetadata(metadata, name, ((COSString)value).getString());
        } else if (value != null) {
            this.addMetadata(metadata, name, value.toString());
        }
    }

    public void setPDFParserConfig(PDFParserConfig config) {
        this.defaultConfig = config;
    }

    public PDFParserConfig getPDFParserConfig() {
        return this.defaultConfig;
    }

    public void setUseNonSequentialParser(boolean v) {
        this.defaultConfig.setUseNonSequentialParser(v);
    }

    public boolean getUseNonSequentialParser() {
        return this.defaultConfig.getUseNonSequentialParser();
    }

    public void setEnableAutoSpace(boolean v) {
        this.defaultConfig.setEnableAutoSpace(v);
    }

    public boolean getEnableAutoSpace() {
        return this.defaultConfig.getEnableAutoSpace();
    }

    public void setExtractAnnotationText(boolean v) {
        this.defaultConfig.setExtractAnnotationText(v);
    }

    public boolean getExtractAnnotationText() {
        return this.defaultConfig.getExtractAnnotationText();
    }

    public void setSuppressDuplicateOverlappingText(boolean v) {
        this.defaultConfig.setSuppressDuplicateOverlappingText(v);
    }

    public boolean getSuppressDuplicateOverlappingText() {
        return this.defaultConfig.getSuppressDuplicateOverlappingText();
    }

    public void setSortByPosition(boolean v) {
        this.defaultConfig.setSortByPosition(v);
    }

    public boolean getSortByPosition() {
        return this.defaultConfig.getSortByPosition();
    }
}

