/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.tika.metadata.Metadata;

@Provider
@Produces(value={"text/plain"})
public class TextMessageBodyWriter
implements MessageBodyWriter<Metadata> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.equals(MediaType.TEXT_PLAIN_TYPE) && Metadata.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Metadata data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Metadata metadata, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (metadata.names().length != 1) {
            throw new WebApplicationException("Metadata object must only have one entry!");
        }
        OutputStreamWriter writer = new OutputStreamWriter(entityStream, "UTF-8");
        for (String name : metadata.names()) {
            writer.write(metadata.get(name));
        }
        ((Writer)writer).flush();
    }
}

