/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Provider
@PreMatching
public class TikaLoggingFilter
implements ContainerRequestFilter {
    private static final Log logger = LogFactory.getLog(TikaLoggingFilter.class);
    private boolean infoLevel;

    public TikaLoggingFilter(boolean infoLevel) {
        this.infoLevel = infoLevel;
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String requestUri = requestContext.getUriInfo().getRequestUri().toString();
        String logMessage = "Request URI: " + requestUri;
        if (this.infoLevel) {
            logger.info(logMessage);
        } else {
            logger.debug(logMessage);
        }
    }
}

