/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.server.HTMLHelper;
import org.eclipse.jetty.util.ajax.JSON;

@Path(value="/parsers")
public class TikaParsers {
    private static final ParseContext EMPTY_PC = new ParseContext();
    private TikaConfig tika;
    private HTMLHelper html;

    public TikaParsers(TikaConfig tika) {
        this.tika = tika;
        this.html = new HTMLHelper();
    }

    @GET
    @Path(value="/details")
    @Produces(value={"text/html"})
    public String getParserDetailsHTML() {
        return this.getParsersHTML(true);
    }

    @GET
    @Produces(value={"text/html"})
    public String getParsersHTML() {
        return this.getParsersHTML(false);
    }

    protected String getParsersHTML(boolean withMimeTypes) {
        ParserDetails p = new ParserDetails(this.tika.getParser());
        StringBuffer h = new StringBuffer();
        this.html.generateHeader(h, "Parsers available to Apache Tika");
        this.parserAsHTML(p, withMimeTypes, h, 2);
        this.html.generateFooter(h);
        return h.toString();
    }

    private void parserAsHTML(ParserDetails p, boolean withMimeTypes, StringBuffer html, int level) {
        html.append("<h");
        html.append(level);
        html.append(">");
        html.append(p.shortName);
        html.append("</h");
        html.append(level);
        html.append(">");
        html.append("<p>Class: ");
        html.append(p.className);
        html.append("</p>");
        if (p.isDecorated) {
            html.append("<p>Decorated Parser</p>");
        }
        if (p.isComposite) {
            html.append("<p>Composite Parser</p>");
            for (Parser cp : p.childParsers) {
                this.parserAsHTML(new ParserDetails(cp), withMimeTypes, html, level + 1);
            }
        } else if (withMimeTypes) {
            html.append("<p>Mime Types:");
            html.append("<ul>");
            for (MediaType mt : p.supportedTypes) {
                html.append("<li>");
                html.append(mt.toString());
                html.append("</li>");
            }
            html.append("</ul>");
            html.append("</p>");
        }
    }

    @GET
    @Path(value="/details")
    @Produces(value={"application/json"})
    public String getParserDetailsJSON() {
        return this.getParsersJSON(true);
    }

    @GET
    @Produces(value={"application/json"})
    public String getParsersJSON() {
        return this.getParsersJSON(false);
    }

    protected String getParsersJSON(boolean withMimeTypes) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        this.parserAsMap(new ParserDetails(this.tika.getParser()), withMimeTypes, details);
        return JSON.toString(details);
    }

    private void parserAsMap(ParserDetails p, boolean withMimeTypes, Map<String, Object> details) {
        details.put("name", p.className);
        details.put("composite", p.isComposite);
        details.put("decorated", p.isDecorated);
        if (p.isComposite) {
            ArrayList<HashMap<String, Object>> c = new ArrayList<HashMap<String, Object>>();
            for (Parser cp : p.childParsers) {
                HashMap<String, Object> cdet = new HashMap<String, Object>();
                this.parserAsMap(new ParserDetails(cp), withMimeTypes, cdet);
                c.add(cdet);
            }
            details.put("children", c);
        } else if (withMimeTypes) {
            ArrayList<String> mts = new ArrayList<String>(p.supportedTypes.size());
            for (MediaType mt : p.supportedTypes) {
                mts.add(mt.toString());
            }
            details.put("supportedTypes", mts);
        }
    }

    @GET
    @Path(value="/details")
    @Produces(value={"text/plain"})
    public String getParserDetailssPlain() {
        return this.getParsersPlain(true);
    }

    @GET
    @Produces(value={"text/plain"})
    public String getParsersPlain() {
        return this.getParsersPlain(false);
    }

    protected String getParsersPlain(boolean withMimeTypes) {
        StringBuffer text = new StringBuffer();
        this.renderParser(new ParserDetails(this.tika.getParser()), withMimeTypes, text, "");
        return text.toString();
    }

    private void renderParser(ParserDetails p, boolean withMimeTypes, StringBuffer text, String indent) {
        block4: {
            String nextIndent;
            block3: {
                nextIndent = indent + "  ";
                text.append(indent);
                text.append(p.className);
                if (p.isDecorated) {
                    text.append(" (Decorated Parser)");
                }
                if (!p.isComposite) break block3;
                text.append(" (Composite Parser):\n");
                for (Parser cp : p.childParsers) {
                    this.renderParser(new ParserDetails(cp), withMimeTypes, text, nextIndent);
                }
                break block4;
            }
            text.append("\n");
            if (!withMimeTypes) break block4;
            for (MediaType mt : p.supportedTypes) {
                text.append(nextIndent);
                text.append("Supports: ");
                text.append(mt.toString());
                text.append("\n");
            }
        }
    }

    private static class ParserDetails {
        private String className;
        private String shortName;
        private boolean isComposite;
        private boolean isDecorated;
        private Set<MediaType> supportedTypes;
        private List<Parser> childParsers;

        private ParserDetails(Parser p) {
            if (p instanceof ParserDecorator) {
                this.isDecorated = true;
                p = ((ParserDecorator)p).getWrappedParser();
            }
            this.className = p.getClass().getName();
            this.shortName = this.className.substring(this.className.lastIndexOf(46) + 1);
            if (p instanceof CompositeParser) {
                this.isComposite = true;
                this.supportedTypes = Collections.emptySet();
                HashSet<Parser> children = new HashSet<Parser>(((CompositeParser)p).getParsers(EMPTY_PC).values());
                this.childParsers = new ArrayList<Parser>(children);
                Collections.sort(this.childParsers, new Comparator<Parser>(){

                    @Override
                    public int compare(Parser p1, Parser p2) {
                        return p1.getClass().getName().compareTo(p2.getClass().getName());
                    }
                });
            } else {
                this.supportedTypes = p.getSupportedTypes(EMPTY_PC);
            }
        }
    }
}

