/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.StructureData;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class StationDatasetCollection {
    private boolean debug = false;
    private ArrayList sobsList = new ArrayList();
    private StationObsDataset typical = null;
    private StringBuilder log = new StringBuilder();

    public void add(String location) throws IOException {
        StationObsDataset sobs = (StationObsDataset)TypedDatasetFactory.open(FeatureType.STATION, location, null, this.log);
        if (this.typical == null) {
            this.typical = sobs;
        }
        this.sobsList.add(sobs);
    }

    public List getStations() throws IOException {
        return this.typical.getStations();
    }

    public List getStations(LatLonRect boundingBox) throws IOException {
        return this.typical.getStations(boundingBox);
    }

    public Station getStation(String name) {
        return this.typical.getStation(name);
    }

    public DataIterator getDataIterator(Station s) throws IOException {
        return new StationDataIterator(s);
    }

    public DataIterator getDataIterator(Station s, Date start, Date end) throws IOException {
        return new StationDateDataIterator(s, start, end);
    }

    public static void main(String[] args) throws IOException, ParseException {
        StationDatasetCollection sdc = new StationDatasetCollection();
        DateFormatter format = new DateFormatter();
        sdc.add("C:/data/metars/Surface_METAR_20070326_0000.nc");
        sdc.add("C:/data/metars/Surface_METAR_20070329_0000.nc");
        sdc.add("C:/data/metars/Surface_METAR_20070330_0000.nc");
        sdc.add("C:/data/metars/Surface_METAR_20070331_0000.nc");
        Station s = sdc.getStation("ACK");
        DataIterator iter = sdc.getDataIterator(s);
        while (iter.hasNext()) {
            Object o = iter.nextData();
            assert (o instanceof StationObsDatatype);
            StationObsDatatype sod = (StationObsDatatype)o;
            Station ss = sod.getStation();
            assert (ss.getName().equals(s.getName()));
            System.out.println(ss.getName() + " " + format.toDateTimeStringISO(sod.getObservationTimeAsDate()));
            StructureData sdata = sod.getData();
            assert (sdata != null);
        }
        System.out.println("------------------\n");
        Date start = format.isoDateTimeFormat("2007-03-27T09:18:56Z");
        Date end = format.isoDateTimeFormat("2007-03-30T10:52:48Z");
        iter = sdc.getDataIterator(s, start, end);
        while (iter.hasNext()) {
            Object o = iter.nextData();
            assert (o instanceof StationObsDatatype);
            StationObsDatatype sod = (StationObsDatatype)o;
            Station ss = sod.getStation();
            assert (ss.getName().equals(s.getName()));
            System.out.println(ss.getName() + " " + format.toDateTimeStringISO(sod.getObservationTimeAsDate()));
            StructureData sdata = sod.getData();
            assert (sdata != null);
        }
    }

    private class StationDateDataIterator
    extends StationDataIterator {
        private Date want_start;
        private Date want_end;

        StationDateDataIterator(Station s, Date start, Date end) throws IOException {
            super(s);
            this.want_start = start;
            this.want_end = end;
        }

        @Override
        protected DataIterator makeDataIterator(StationObsDataset sobs) {
            Date start = sobs.getStartDate();
            if (start.after(this.want_end)) {
                return null;
            }
            Date end = sobs.getEndDate();
            if (end.before(this.want_start)) {
                return null;
            }
            Station s = sobs.getStation(this.stationName);
            if (s == null) {
                return null;
            }
            return sobs.getDataIterator(s, start, end);
        }
    }

    private class StationDataIterator
    implements DataIterator {
        String stationName;
        Iterator iterSobs;
        DataIterator dataIter;

        StationDataIterator(Station s) throws IOException {
            this.stationName = s.getName();
            this.iterSobs = StationDatasetCollection.this.sobsList.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.dataIter == null) {
                this.dataIter = this.getNextDataIterator();
            }
            if (this.dataIter == null) {
                return false;
            }
            if (this.dataIter.hasNext()) {
                return true;
            }
            this.dataIter = this.getNextDataIterator();
            if (this.dataIter == null) {
                return false;
            }
            return this.hasNext();
        }

        @Override
        public Object nextData() throws IOException {
            return this.dataIter.nextData();
        }

        @Override
        public Object next() {
            return this.dataIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private DataIterator getNextDataIterator() {
            if (!this.iterSobs.hasNext()) {
                return null;
            }
            StationObsDataset sobs = (StationObsDataset)this.iterSobs.next();
            DataIterator dataIter = this.makeDataIterator(sobs);
            if (StationDatasetCollection.this.debug && dataIter != null) {
                System.out.println("next sobs =" + sobs.getLocationURI());
            }
            return dataIter == null ? this.getNextDataIterator() : dataIter;
        }

        protected DataIterator makeDataIterator(StationObsDataset sobs) {
            Station s = sobs.getStation(this.stationName);
            if (s == null) {
                return null;
            }
            return sobs.getDataIterator(s);
        }
    }
}

