/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.DatasetCollectionManager;
import thredds.inventory.TimedCollection;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.collection.CompositePointCollection;
import ucar.nc2.ft.point.collection.CompositeStationCollection;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public class CompositeDatasetFactory {
    public static final String SCHEME = "collection:";
    private static Logger log = LoggerFactory.getLogger(CompositeDatasetFactory.class);
    static boolean debug = true;

    public static FeatureDataset factory(String location, FeatureType wantFeatureType, DatasetCollectionManager dcm, Formatter errlog) throws IOException {
        TimedCollection collection = new TimedCollection(dcm, errlog);
        if (collection.getDatasets().size() == 0) {
            throw new FileNotFoundException("Collection is empty; spec=" + dcm);
        }
        if (wantFeatureType == FeatureType.ANY_POINT) {
            TimedCollection.Dataset d = collection.getPrototype();
            FeatureDatasetPoint proto = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.ANY_POINT, d.getLocation(), null, errlog);
            wantFeatureType = proto.getFeatureType();
            proto.close();
        }
        FeatureCollection fc = null;
        switch (wantFeatureType) {
            case POINT: {
                CompositePointCollection pfc;
                fc = pfc = new CompositePointCollection(dcm.getCollectionName(), collection);
                break;
            }
            case STATION: {
                CompositeStationCollection sfc = new CompositeStationCollection(dcm.getCollectionName(), collection, null, null);
                fc = sfc;
                break;
            }
            default: {
                return null;
            }
        }
        return new CompositePointDataset(location, wantFeatureType, fc, collection, null);
    }

    private static class CompositePointDataset
    extends PointDatasetImpl
    implements UpdateableCollection {
        private TimedCollection datasets;
        private FeatureCollection pfc;

        public CompositePointDataset(String location, FeatureType featureType, FeatureCollection pfc, TimedCollection datasets, LatLonRect bb) {
            super(featureType);
            this.setLocationURI(location);
            this.setPointFeatureCollection(pfc);
            this.pfc = pfc;
            this.datasets = datasets;
            if (datasets.getDateRange() != null) {
                this.setDateRange(datasets.getDateRange());
            }
            if (bb != null) {
                this.setBoundingBox(bb);
            }
        }

        @Override
        public List<VariableSimpleIF> getDataVariables() {
            if (this.dataVariables == null) {
                if (this.pfc instanceof CompositePointCollection) {
                    this.dataVariables = ((CompositePointCollection)this.pfc).getDataVariables();
                } else if (this.pfc instanceof CompositeStationCollection) {
                    this.dataVariables = ((CompositeStationCollection)this.pfc).getDataVariables();
                }
            }
            return this.dataVariables;
        }

        @Override
        protected void setDateRange(DateRange dateRange) {
            super.setDateRange(dateRange);
        }

        @Override
        protected void setBoundingBox(LatLonRect boundingBox) {
            super.setBoundingBox(boundingBox);
        }

        @Override
        public void update() {
            ((UpdateableCollection)((Object)this.pfc)).update();
        }

        @Override
        public NetcdfFile getNetcdfFile() {
            TimedCollection.Dataset td = this.datasets.getPrototype();
            if (td == null) {
                return null;
            }
            String loc = td.getLocation();
            Formatter errlog = new Formatter();
            try {
                FeatureDatasetPoint proto = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.ANY_POINT, loc, null, errlog);
                return proto.getNetcdfFile();
            }
            catch (IOException e) {
                log.error(errlog.toString());
                e.printStackTrace();
                return null;
            }
        }
    }
}

