/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.AbstractTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoshuaNetworkTranslator
extends AbstractTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(JoshuaNetworkTranslator.class);
    private static final String PROPERTIES_FILE = "translator.joshua.properties";
    private static final String JOSHUA_SERVER = "joshua.server.url";
    private String networkServer;
    private String networkURI;

    public JoshuaNetworkTranslator() {
        Properties props = new Properties();
        InputStream stream = JoshuaNetworkTranslator.class.getResourceAsStream(PROPERTIES_FILE);
        try {
            if (stream != null) {
                props.load(stream);
                this.networkServer = props.getProperty(JOSHUA_SERVER);
            }
        }
        catch (IOException e) {
            LOG.error("An error occured whilst reading translator.joshua.properties file", (Throwable)e);
        }
    }

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        String line;
        this.networkURI = !this.networkServer.endsWith("/") ? this.networkServer + "/" + targetLanguage : this.networkServer + targetLanguage;
        if (!this.isAvailable()) {
            return text;
        }
        if (sourceLanguage == null) {
            sourceLanguage = this.detectLanguage(text).getLanguage();
        }
        StringBuilder sb = new StringBuilder(text);
        int i = 0;
        while ((i = sb.indexOf(".", i + 1)) != -1) {
            sb.replace(i, i + 1, "\n");
        }
        String inputText = sb.toString();
        ArrayList<JacksonJsonProvider> providers = new ArrayList<JacksonJsonProvider>();
        JacksonJsonProvider jacksonJsonProvider = new JacksonJsonProvider();
        providers.add(jacksonJsonProvider);
        WebClient client = WebClient.create((String)this.networkURI, providers);
        ObjectMapper requestMapper = new ObjectMapper();
        ObjectNode jsonNode = requestMapper.createObjectNode();
        jsonNode.put("inputLanguage", sourceLanguage);
        jsonNode.put("inputText", inputText);
        Response response = client.accept(new String[]{"application/json"}).type("application/json").post((Object)jsonNode);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        StringBuilder responseText = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            responseText.append(line);
        }
        try {
            ObjectMapper responseMapper = new ObjectMapper();
            JsonNode jsonResp = responseMapper.readTree(responseText.toString());
            if (jsonResp.findValuesAsText("outputText") != null) {
                return (String)jsonResp.findValuesAsText("outputText").get(0);
            }
            throw new TikaException(jsonResp.findValue("message").get(0).asText());
        }
        catch (JsonParseException e) {
            throw new TikaException("Error requesting translation from '" + sourceLanguage + "' to '" + targetLanguage + "', JSON response from Joshua REST Server is not well formatted: " + responseText.toString());
        }
    }

    @Override
    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        if (this.isAvailable()) {
            return text;
        }
        String sourceLanguage = this.detectLanguage(text).getLanguage();
        return this.translate(text, sourceLanguage, targetLanguage);
    }

    @Override
    public boolean isAvailable() {
        if (this.networkServer != null) {
            URL url = null;
            try {
                url = new URL(this.networkURI);
            }
            catch (MalformedURLException mue) {
                LOG.error("Error reading {} property from {}. {}", new Object[]{JOSHUA_SERVER, PROPERTIES_FILE, mue});
            }
            HttpURLConnection connection = null;
            try {
                if (url != null) {
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestProperty("Connection", "close");
                    connection.setConnectTimeout(2000);
                    connection.connect();
                    return this.tryResponseCode(connection);
                }
            }
            catch (IOException ioe) {
                LOG.error("Error whilst checking availability of {}. {}", (Object)JOSHUA_SERVER, (Object)ioe);
            }
        }
        return false;
    }

    private boolean tryResponseCode(HttpURLConnection connection) {
        try {
            if (connection.getResponseCode() == 200) {
                return true;
            }
        }
        catch (IOException ioe) {
            LOG.error("Error retreiving response code from Joshua Network Translator. {}", (Throwable)ioe);
        }
        return false;
    }
}

