/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate;

import com.fasterxml.jackson.databind.util.LRUMap;
import java.io.IOException;
import java.util.HashMap;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.detect.LanguageResult;
import org.apache.tika.language.translate.AbstractTranslator;
import org.apache.tika.language.translate.Translator;

public class CachedTranslator
extends AbstractTranslator {
    private static final int INITIAL_ENTRIES = 100;
    private static final int MAX_ENTRIES = 1000;
    private Translator translator;
    private HashMap<String, LRUMap<String, String>> cache;

    public CachedTranslator() {
        this(null);
    }

    public CachedTranslator(Translator translator) {
        this.translator = translator;
        this.cache = new HashMap();
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        if (this.translator == null) {
            return text;
        }
        LRUMap<String, String> translationCache = this.getTranslationCache(sourceLanguage, targetLanguage);
        String translatedText = (String)translationCache.get((Object)text);
        if (translatedText == null) {
            translatedText = this.translator.translate(text, sourceLanguage, targetLanguage);
            translationCache.put((Object)text, (Object)translatedText);
        }
        return translatedText;
    }

    @Override
    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        LanguageResult language = this.detectLanguage(text);
        String sourceLanguage = language.getLanguage();
        return this.translate(text, sourceLanguage, targetLanguage);
    }

    @Override
    public boolean isAvailable() {
        return this.translator != null && this.translator.isAvailable();
    }

    public int getNumTranslationPairs() {
        return this.cache.size();
    }

    public int getNumTranslationsFor(String sourceLanguage, String targetLanguage) {
        LRUMap<String, String> translationCache = this.cache.get(this.buildCacheKeyString(sourceLanguage, targetLanguage));
        if (translationCache == null) {
            return 0;
        }
        return translationCache.size();
    }

    public boolean contains(String text, String sourceLanguage, String targetLanguage) {
        LRUMap<String, String> translationCache = this.getTranslationCache(sourceLanguage, targetLanguage);
        return translationCache.get((Object)text) != null;
    }

    public boolean contains(String text, String targetLanguage) {
        try {
            LanguageResult language = this.detectLanguage(text);
            String sourceLanguage = language.getLanguage();
            return this.contains(text, sourceLanguage, targetLanguage);
        }
        catch (IOException e) {
            return false;
        }
    }

    private String buildCacheKeyString(String sourceLanguage, String targetLanguage) {
        return sourceLanguage + ":" + targetLanguage;
    }

    private LRUMap<String, String> getTranslationCache(String sourceLanguage, String targetLanguage) {
        LRUMap translationCache = this.cache.get(this.buildCacheKeyString(sourceLanguage, targetLanguage));
        if (translationCache == null) {
            translationCache = new LRUMap(100, 1000);
            this.cache.put(this.buildCacheKeyString(sourceLanguage, targetLanguage), (LRUMap<String, String>)translationCache);
        }
        return translationCache;
    }
}

